#include <iostream>
#include <vector>
#include <stack>

using namespace std;

int n;
vector<vector<int>> adj;
vector<bool> visited;

bool dfs(int node, int start, int count) {
    visited[node] = true;
    if (count == n) {
        if (adj[node][0] == start) {
            return true;
        } else {
            visited[node] = false;
            return false;
        }
    }

    for (int i = 0; i < adj[node].size(); i++) {
        int next = adj[node][i];
        if (!visited[next]) {
            if (dfs(next, start, count + 1)) {
                return true;
            }
        }
    }

    visited[node] = false;
    return false;
}

int main() {
    cin >> n;
    adj.resize(n + 1);
    visited.resize(n + 1, false);

    for (int i = 5; i <= n; i++) {
        int a, b, c;
        cin >> a >> b >> c;
        adj[a].push_back(i);
        adj[b].push_back(i);
        adj[c].push_back(i);
    }

    if (!dfs(1, 1, 1)) {
        cout << -1 << endl;
    } else {
        for (int i = 1; i <= n; i++) {
            cout << i << " ";
        }
        cout << endl;
    }

    return 0;
}