#include <iostream>
#include <vector>
using namespace std;

bool pronadjiCiklus(int trenutni, int duzina, int brojCvorova, const vector<vector<int>>& veze, vector<bool>& poseceni, vector<int>& put) {
    if (duzina == brojCvorova) {
        for (int sused : veze[trenutni]) {
            if (sused == 0) {
                put.push_back(0);
                return true;
            }
        }
        return false;
    }

    for (int sused : veze[trenutni]) {
        if (!poseceni[sused]) {
            poseceni[sused] = true;
            put.push_back(sused);
            if (pronadjiCiklus(sused, duzina + 1, brojCvorova, veze, poseceni, put)) {
                return true;
            }
            poseceni[sused] = false;
            put.pop_back();
        }
    }

    return false;
}

int main() {
    int brojCvorova;
    cin >> brojCvorova;

    vector<vector<int>> veze(brojCvorova);

   
    veze[0] = { 1, 2, 3 };
    veze[1] = { 0, 2, 3 };
    veze[2] = { 0, 1, 3 };
    veze[3] = { 0, 1, 2 };

   
    for (int i = 4; i < brojCvorova; i++) {
        int a, b, c;
        cin >> a >> b >> c;
        a--; b--; c--;
        veze[i] = { a, b, c };
        veze[a].push_back(i);
        veze[b].push_back(i);
        veze[c].push_back(i);
    }

    vector<bool> poseceni(brojCvorova, false);
    vector<int> put;

   
    poseceni[0] = true;
    put.push_back(0);
    if (pronadjiCiklus(0, 1, brojCvorova, veze, poseceni, put)) {
        for (int cvor : put) {
            cout << cvor + 1 << " ";
        }
        cout << endl;
    }
    else {
        cout << "-1" << endl;
    }

    return 0;
}