#include <iostream>
#include <vector>
#include <queue>
using namespace std;

int main() {
    int n;
    cin >> n; // Broj prodavnica

    vector<vector<int>> graph(n + 1);
    for (int i = 0; i < n - 4; i++) {
        int a, b, c;
        cin >> a >> b >> c; // Trojke prodavnica
        graph[a].push_back(b);
        graph[a].push_back(c);
        graph[b].push_back(a);
        graph[b].push_back(c);
        graph[c].push_back(a);
        graph[c].push_back(b);
    }

    vector<int> poseta(n + 1, 0);
    vector<int> redosled;
    queue<int> q;

    for (int i = 1; i <= n; i++) {
        if (graph[i].size() == 2) {
            q.push(i);
            poseta[i] = 1;
            redosled.push_back(i);
            break;
        }
    }

    while (!q.empty()) {
        int curr = q.front();
        q.pop();

        for (int sused : graph[curr]) {
            if (!poseta[sused]) {
                poseta[sused] = 1;
                redosled.push_back(sused);
                q.push(sused);
                break;
            }
        }
    }

    cout << "\nRedosled obilaska prodavnica: ";
    for (int prodavnica : redosled) {
        cout << prodavnica << " ";
    }
    cout << "1" << endl;

    return 0;
}