#include <iostream>
#include <vector>
#include <string>
#include <stack>
#include <queue>
#include <algorithm>
#include <cmath>
#include <deque>

using namespace std;

#define int long long

vector<vector<int>> adj;  
vector<bool> visited;     
vector<int> path; 

bool dfs(int i, int cnt) 
{
    visited[i] = true;
    path.push_back(i);
    if (cnt == adj.size()-1 && find(adj[i].begin(), adj[i].end(), 1) != adj[i].end()) 
    {
        path.push_back(1); 
        return true;
    }
    for (auto j : adj[i]) 
    {
        if (!visited[j]) 
        {
            if (dfs(j, cnt + 1)) 
            {
                return true;
            }
        }
    }
    visited[i] = false;
    path.pop_back();
    return false;
}

signed main() 
{
    int n;
    cin >> n; 
    adj.resize(n + 1);
    adj[1].push_back(2);
    adj[1].push_back(3);
    adj[1].push_back(4);
    adj[2].push_back(3);
    adj[2].push_back(1);
    adj[2].push_back(4);
    adj[3].push_back(1);
    adj[3].push_back(2);
    adj[3].push_back(4);
    adj[4].push_back(1);
    adj[4].push_back(2);
    adj[4].push_back(3);
    for (int i = 5; i <= n; i++) 
    {
        int a,b,c;
        cin >> a >> b >> c;
        adj[i].push_back(a);
        adj[i].push_back(b);
        adj[i].push_back(c);
        adj[a].push_back(i);
        adj[b].push_back(i);
        adj[c].push_back(i);
    }
    visited.assign(n+1, false);  
    visited[0] = true;
    if (dfs(1,1)) 
    {
        for (auto i : path) 
        {
            cout << i << " ";
        }
    }
    else 
    {
        cout << -1;
    }
}