#include <bits/stdc++.h>
using namespace std;
bool provera(const vector<vector<int>>& graph, const vector<int>& path) {
    int n = path.size();
    for (int i = 0; i < n - 1; i++) {
        if (graph[path[i]][path[i + 1]] == 0) {
            return false;
        }
}
    if(graph[path[n - 1]][path[0]]== 0) {
        return false;
    }
    return true;
}

vector<int> prolazak(const vector<vector<int>>& graph, int n) {
    vector<int> cvorovi;
    for (int i = 1; i < n; i++) {
        cvorovi.push_back(i);}
    
    do {
        vector<int> path = {0};
        path.insert(path.end(), cvorovi.begin(), cvorovi.end());

        if (provera(graph, path)) {
            for (int& node : path) {
                node++;
            }
            return path;
        }
    } while (next_permutation(cvorovi.begin(), cvorovi.end()));

    return {};
}

int main() {
    int n;
    cin >> n;
    vector<vector<int>>graph(n,vector<int>(n, 0));

    graph[0][1] = graph[1][0] = 1;
    graph[0][2] = graph[2][0] = 1;
    graph[1][2] = graph[2][1] = 1;

    graph[3][0] = graph[0][3] = 1;
    graph[3][1] = graph[1][3] = 1;
    graph[3][2] = graph[2][3] = 1;

    for (int i = 4; i < n; i++) {
        int a, b, c;
        cin >> a >> b >> c;
        a--; b--; c--;
        graph[i][a] = graph[a][i] = 1;
        graph[i][b] = graph[b][i] = 1;
        graph[i][c] = graph[c][i] = 1;
    }

    vector<int> result = prolazak(graph, n);

    if (result.empty()) {
        cout << -1 << endl;
    } else {
        for (int i = 0; i < result.size(); i++) {
            cout << result[i] << " ";
        }
        cout << result[0] << endl;
    }

    return 0;
}