#include <iostream>
#include <vector>
#include <algorithm>
#include <functional>
using namespace std;

vector<int> pronadjiPutanju(int n, vector<pair<int, int>> &veze)
{
    vector<vector<int>> graf(n + 1);
    for (auto &veza : veze)
    {
        graf[veza.first].push_back(veza.second);
        graf[veza.second].push_back(veza.first);
    }

    vector<int> putanja = {1};
    vector<bool> poseceno(n + 1, false);
    poseceno[1] = true;

    std::function<bool(int)> dfs = [&](int cvor) -> bool
    {
        if (putanja.size() == n)
        {
            return find(graf[cvor].begin(), graf[cvor].end(), 1) != graf[cvor].end();
        }

        for (int susedni : graf[cvor])
        {
            if (!poseceno[susedni])
            {
                poseceno[susedni] = true;
                putanja.push_back(susedni);

                if (dfs(susedni))
                {
                    return true;
                }

                poseceno[susedni] = false;
                putanja.pop_back();
            }
        }

        return false;
    };

    if (dfs(1))
    {
        putanja.push_back(1);
        return putanja;
    }

    return {};
}

int main()
{
    int n;
    cin >> n;
    vector<pair<int, int>> veze = {
        {1, 2}, {1, 3}, {1, 4}, {2, 3}, {2, 4}, {3, 4}};
    for (int i = 4; i < n; i++)
    {
        int a, b, c;
        cin >> a >> b >> c;
        veze.push_back({i + 1, a});
        veze.push_back({i + 1, b});
        veze.push_back({i + 1, c});
    }

    vector<int> putanja = pronadjiPutanju(n, veze);

    if (!putanja.empty())
    {
        for (int cvor : putanja)
        {
            cout << cvor << " ";
        }
        cout << endl;
    }
    else
    {
        cout << -1 << endl;
    }

    return 0;
}