#include <iostream>
#include <vector>
using namespace std;

int solve(vector<int>& a, vector<vector<vector<int>>>& dp, int m, int l, int r, int currRound, int currIgrac) {
  if (l > r) return 0;
  if (dp[l][r][currRound] != -1) return dp[l][r][currRound];

  if (currRound == currIgrac) {
    dp[l][r][currRound] = max(
      a[l] + solve(a, dp, m, l+1, r, (currRound+1)%m, currIgrac),
      a[r] + solve(a, dp, m, l, r-1, (currRound+1)%m, currIgrac)
    );
    return dp[l][r][currRound];
  } else {
    int levi = solve(a, dp, m, l+1, r, (currRound+1)%m, currIgrac);
    int desni = solve(a, dp, m, l, r-1, (currRound+1)%m, currIgrac);
    dp[l][r][currRound] = min(levi, desni);
    return dp[l][r][currRound];
  }
}

int main() {
  int n, m, res;
  scanf("%d %d", &n, &m);
  vector<int> a(n);
  for(int i = 0; i < n; i++) {
    scanf("%d", &a[i]);
  }

  vector<vector<vector<int>>> dp(n, vector<vector<int>>(n, vector<int>(m, -1)));

  for (int i=0; i<m; i++) {
    for (int j=0; j<n; j++) {
      for (int k=0; k<n; k++) {
        fill(dp[j][k].begin(), dp[j][k].end(), -1);
      }
    }
    res = solve(a, dp, m, 0, n-1, 0, i);
    printf("%d ", res);
  }
  return 0;
}