#include <iostream>
#include <vector>
#include <stack>
using namespace std;

vector<int> adj[200005]; // Adjacency list
vector<int> result; // Resultant path

void dfs(int v, int& pos) {
    while (adj[v].size()) {
        int u = adj[v].back();
        adj[v].pop_back();
        dfs(u, pos);
    }
    result.push_back(v);
}

int main() {
    int n;
    cin >> n;

    // Initialize the first three stores (1, 2, 3)
    for (int i = 2; i <= 3; i++)
        adj[1].push_back(i), adj[i].push_back(1);

    // Read and build the graph for stores from 4 to n
    for (int i = 4; i <= n; i++) {
        int a, b, c;
        cin >> a >> b >> c;
        adj[i].push_back(a);
        adj[i].push_back(b);
        adj[i].push_back(c);
        adj[a].push_back(i);
        adj[b].push_back(i);
        adj[c].push_back(i);
    }

    result.push_back(1); // Start from store 1

    // Perform DFS from store 1
    int pos = 1;
    dfs(1, pos);
    
    result.push_back(1); // Return to the starting point

    // Output the result
    for (int store : result)
        cout << store << " ";
    
    return 0;
}