#include <iostream>
#include <vector>
#include <unordered_set>
using namespace std;

void dfs(int node, vector<vector<int>>& graph, vector<int>& path, vector<bool>& visited) {
    visited[node] = true;
    path.push_back(node);
    for (int neighbor : graph[node]) {
        if (!visited[neighbor]) {
            dfs(neighbor, graph, path, visited);
        }
    }
}

int main() {
    int n;
    cin >> n;

    vector<vector<int>> graph(n + 1);
    for (int i = 4; i <= n; ++i) {
        int a, b, c;
        cin >> a >> b >> c;
        graph[i].push_back(a);
        graph[i].push_back(b);
        graph[i].push_back(c);
        graph[a].push_back(i);
        graph[b].push_back(i);
        graph[c].push_back(i);
    }

    vector<int> path;
    vector<bool> visited(n + 1, false);
    dfs(1, graph, path, visited);

    path.push_back(1); // Return to the starting point
    for (int node : path) {
        cout << node << " ";
    }
    cout << endl;

    return 0;
}