#include <iostream>
#include <vector>
#include <set>
#include <algorithm>

using namespace std;

vector<set<int>> lista_suseda;
vector<int> rezultat;
vector<bool> poseceno;

bool pretraga_tacaka(int cvor, int n) {
    rezultat.push_back(cvor);
    poseceno[cvor] = true;

    if (rezultat.size() == n) {
        if (lista_suseda[cvor].find(1) != lista_suseda[cvor].end()) {
            rezultat.push_back(1);
            return true;
        } else {
            rezultat.pop_back();
            poseceno[cvor] = false;
            return false;
        }
    }

    for (int susedni : lista_suseda[cvor]) {
        if (!poseceno[susedni]) {
            if (pretraga_tacaka(susedni, n)) {
                return true;
            }
        }
    }

    rezultat.pop_back();
    poseceno[cvor] = false;
    return false;
}

int main() {
    int n;
    cin >> n;

    lista_suseda.resize(n + 1);
    poseceno.resize(n + 1, false);

    lista_suseda[1].insert(2);
    lista_suseda[1].insert(3);
    lista_suseda[2].insert(1);
    lista_suseda[2].insert(3);
    lista_suseda[3].insert(1);
    lista_suseda[3].insert(2);

    for (int i = 5; i <= n; ++i) {
        int a, b, c;
        cin >> a >> b >> c;
        lista_suseda[i].insert(a);
        lista_suseda[i].insert(b);
        lista_suseda[i].insert(c);
        lista_suseda[a].insert(i);
        lista_suseda[b].insert(i);
        lista_suseda[c].insert(i);
    }

    if (pretraga_tacaka(1, n)) {
        for (int cvor : rezultat) {
            cout << cvor << " ";
        }
        cout << endl;
    } else {
        cout << -1 << endl;
    }

    return 0;
}