using System;
using System.Collections.Generic;

class Program
{
    static void Main(string[] args)
    {
        string[] prvaLinija = Console.ReadLine().Split();
        int N = int.Parse(prvaLinija[0]);
        int M = int.Parse(prvaLinija[1]);

        string[] drugaLinija = Console.ReadLine().Split();
        int[] nfts = Array.ConvertAll(drugaLinija, int.Parse);

        int[] profiti = new int[M];

        for (int i = 0; i < M; i++)
        {
            profiti[i] = SimulirajIgru(N, M, nfts, i);
        }

        Console.WriteLine(string.Join(" ", profiti));
    }

    static int SimulirajIgru(int N, int M, int[] nfts, int ciljanoBrat)
    {
        LinkedList<int> listaNFTova = new LinkedList<int>(nfts);
        int[] profiti = new int[M];
        int potez = 0;

        while (listaNFTova.Count > 0)
        {
            if (potez % M == ciljanoBrat)
            {
                if (listaNFTova.First.Value >= listaNFTova.Last.Value)
                {
                    profiti[ciljanoBrat] += listaNFTova.First.Value;
                    listaNFTova.RemoveFirst();
                }
                else
                {
                    profiti[ciljanoBrat] += listaNFTova.Last.Value;
                    listaNFTova.RemoveLast();
                }
            }
            else
            {
                if (listaNFTova.First.Value >= listaNFTova.Last.Value)
                {
                    listaNFTova.RemoveFirst();
                }
                else
                {
                    listaNFTova.RemoveLast();
                }
            }

            potez++;
        }

        return profiti[ciljanoBrat];
    }
}