using System;
using System.Collections.Generic;

class Program
{
    static void Main(string[] args)
    {
        string[] prvaLinija = Console.ReadLine().Split();
        int N = int.Parse(prvaLinija[0]);
        int M = int.Parse(prvaLinija[1]);

        string[] drugaLinija = Console.ReadLine().Split();
        int[] nfts = Array.ConvertAll(drugaLinija, int.Parse);

        int[] profiti = new int[M];

        for (int i = 0; i < M; i++)
        {
            profiti[i] = SimulirajIgru(N, M, nfts, i);
        }

        Console.WriteLine(string.Join(" ", profiti));
    }

    static int SimulirajIgru(int N, int M, int[] nfts, int ciljanoBrat)
    {
        int start = 0;
        int end = N - 1;
        int[] profiti = new int[M];
        int potez = 0;

        while (start <= end)
        {
            if (potez % M == ciljanoBrat)
            {
                if (nfts[start] >= nfts[end])
                {
                    profiti[ciljanoBrat] += nfts[start];
                    start++; 
                }
                else
                {
                    profiti[ciljanoBrat] += nfts[end];
                    end--; 
                }
            }
            else
            {
                if (nfts[start] >= nfts[end])
                {
                    start++;
                }
                else
                {
                    end--;
                }
            }

            potez++;
        }

        return profiti[ciljanoBrat];
    }
}