#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

vector<int> path;
vector<vector<int>> graph;
vector<bool> visited;

void dfs(int node) {
    visited[node] = true;
    path.push_back(node);
    for (int neighbor : graph[node]) {
        if (!visited[neighbor]) dfs(neighbor);
    }
}

int main() {
    int n;
    cin >> n;

    graph.resize(n + 1);
    visited.resize(n + 1, false);

    for (int x = 5; x <= n; ++x) {
        int a, b, c;
        cin >> a >> b >> c;
        graph[x].push_back(a);
        graph[x].push_back(b);
        graph[x].push_back(c);
        graph[a].push_back(x);
        graph[b].push_back(x);
        graph[c].push_back(x);
    }

    dfs(1);

    if (path.size() != n) {
        cout << -1 << endl;
    } else {
        path.push_back(1);
        for (int i = 0; i < path.size(); ++i) {
            cout << path[i] << " ";
        }
        cout << endl;
    }

    return 0;
}