using System;
using System.Collections.Generic;

class Program
{
    static void Main(string[] args)
    {
        int n = int.Parse(Console.ReadLine());
        if (n < 4)
        {
            Console.WriteLine("-1");
            return;
        }

        List<(int, int, int)> trouglovi = new List<(int, int, int)>();

        for (int i = 0; i < n - 4; i++)
        {
            string[] ulaz = Console.ReadLine().Split();
            if (ulaz.Length != 3)
            {
                Console.WriteLine("-1");
                return;
            }

            int a = int.Parse(ulaz[0]);
            int b = int.Parse(ulaz[1]);
            int c = int.Parse(ulaz[2]);
            trouglovi.Add((a, b, c));
        }

        var rezultat = PronadjiHamiltonovCiklus(n, trouglovi);

        if (rezultat == null)
        {
            Console.WriteLine("-1");
        }
        else
        {
            Console.WriteLine(string.Join(" ", rezultat));
        }
    }

    static List<int> PronadjiHamiltonovCiklus(int n, List<(int, int, int)> trouglovi)
    {
        Dictionary<int, List<int>> graf = new Dictionary<int, List<int>>();
        for (int i = 1; i <= n; i++)
        {
            graf[i] = new List<int>();
        }


        graf[1].Add(2);
        graf[1].Add(3);
        graf[1].Add(4);
        graf[2].Add(1);
        graf[2].Add(3);
        graf[2].Add(4);
        graf[3].Add(1);
        graf[3].Add(2);
        graf[3].Add(4);
        graf[4].Add(1);
        graf[4].Add(2);
        graf[4].Add(3);


        for (int i = 5; i <= n; i++)
        {
            var (a, b, c) = trouglovi[i - 5];
            graf[i].Add(a);
            graf[i].Add(b);
            graf[i].Add(c);
            graf[a].Add(i);
            graf[b].Add(i);
            graf[c].Add(i);
        }

        List<int> poseceni = new List<int>();
        bool[] poseceneProdavnice = new bool[n + 1];

        bool Dfs(int cvor)
        {
            poseceni.Add(cvor);
            poseceneProdavnice[cvor] = true;

            if (poseceni.Count == n)
            {
                if (graf[cvor].Contains(1))
                {
                    poseceni.Add(1);
                    return true;
                }
                poseceni.RemoveAt(poseceni.Count - 1);
                poseceneProdavnice[cvor] = false;
                return false;
            }

            foreach (var sused in graf[cvor])
            {
                if (!poseceneProdavnice[sused])
                {
                    if (Dfs(sused))
                    {
                        return true;
                    }
                }
            }

            poseceni.RemoveAt(poseceni.Count - 1);
            poseceneProdavnice[cvor] = false;
            return false;
        }

        if (Dfs(1))
        {
            return poseceni;
        }

        return null;
    }
}