#define _CRT_DISABLE_PERFCRIT_LOCKS
#define ll long long
#include <iostream>
#include <algorithm>
#include <cmath>
#include <vector>

using namespace std;

bool vectorIma(vector<int> vec, int v)
{
    for (int i = 0; i < vec.size(); i++) if (vec[i] == v) return true;
    return false;
}

bool siguran(int v, vector<vector<int>>& graph, vector<int>& path, int pos)
{
    if (!vectorIma(graph[path[pos - 1]], v)) return false;
    for (int i = 0; i < pos; i++) if (path[i] == v) return false;
    return true;
}

bool hamilton(vector<vector<int>>& graph, vector<int>& path, int pos, int size)
{
    if (pos == size)
    {
        if (vectorIma(graph[path[pos - 1]], path[0])) return true;
        return false;
    }

    for (int i = 1; i < size; i++)
    {
        if (siguran(i, graph, path, pos))
        {
            path[pos] = i;
            if (hamilton(graph, path, pos + 1, size) == true) return true;
            path[pos] = -1;
        }
    }
    return false;
}

void dodajIvicu(vector<vector<int>>& adj, int s, int t)
{
    adj[s].push_back(t);
    adj[t].push_back(s);
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int brojProdavnica;
    bool trecaGrupa = true;
    cin >> brojProdavnica;

    vector<vector<int>> ulice(brojProdavnica);
    dodajIvicu(ulice, 0, 1);
    dodajIvicu(ulice, 0, 2);
    dodajIvicu(ulice, 1, 2);
    dodajIvicu(ulice, 3, 0);
    dodajIvicu(ulice, 3, 1);
    dodajIvicu(ulice, 3, 2);

    for (int i = 4; i < brojProdavnica; i++)
    {
        int a, b, c;
        cin >> a >> b >> c;
        if (a != 1 && b != 2) trecaGrupa = false;

        dodajIvicu(ulice, i, a - 1);
        dodajIvicu(ulice, i, b - 1);
        dodajIvicu(ulice, i, c - 1);
    }

    if (trecaGrupa)
    {
        cout << "1 2 ";

        for (int i = brojProdavnica; i > 4; i--)
        {
            cout << i << " ";
        }

        cout << "4 3 1";
        return 0;
    }

    vector<int> visited(ulice.size(), -1);
    visited[0] = 0;
    if (!hamilton(ulice, visited, 1, brojProdavnica))
    {
        cout << "-1";
        return 0;
    }

    for (int i = 0; i < visited.size(); i++)
    {
        cout << (visited[i] + 1) << " ";
    }

    cout << "1";
}

/*
                           ####
                  ###     #####
                 ####     #####       ####
                 #####    *###        ####
                  ###      ##        #####
                  ###     ###        ####
         ##       ###     ####       ##+
        ####       ###    ####      ####
         ####     ####    ####     ## #
         *###      ###    ###=     #####
          #####    ###    ###     ####
           ####    ####   ####   ####
           #####    ########## ######
            ####  .###################           ###
             ##=# ###################          ####
              ##################### ##        ######
              ########## #############        ####
              #### #+###### ##########:      ##
              ######## ##  ###+###### :    ##
               ##############+########## # #
               #############################
               ############# ###  #########
                ##########################
                #######################
                  ####################
                   ################

                 PREUZMI ODGOVORNOST!
*/