#include <stdio.h>

#define MAX_N 100

int n;
int graf[MAX_N][MAX_N];
int put[MAX_N];
int pos visited[MAX_N]; 


int daj_na_koju_prodavnicu(int v, int pozicija) {

    if (visited[v]) {
        return 0;
    }
  
    if (graf[put[pozicija - 1]][v] == 0) {
        return 0;
    }

    return 1;
}

int hamiltonov_ciklus(int pozicija) {
    if (pozicija == n) {
      
        return graf[put[pozicija - 1]][put[0]] == 1;
    }

    for (int v = 1; v < n; v++) {
        if (daj_na_koju_prodavnicu(v, pozicija)) {
            put[pozicija] = v;
            visited[v] = 1;

            if (hamiltonov_ciklus(pozicija + 1)) {
                return 1;
            }

            visited[v] = 0;  
        }
    }

    return 0;
}

int main() {
    scanf("%d", &n);

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            graf[i][j] = 0;
        }
    }

   
    graf[0][1] = graf[1][0] = 1;
    graf[0][2] = graf[2][0] = 1;
    graf[1][2] = graf[2][1] = 1;

    for (int i = 4; i < n; i++) {
        int a, b, c;
        scanf("%d %d %d", &a, &b, &c);
        a--; b--; c--;  

        graf[a][i] = graf[i][a] = 1;
        graf[b][i] = graf[i][b] = 1;
        graf[c][i] = graf[i][c] = 1;
    }

 
    put[0] = 0;
    visited[0] = 1;

   
    if (hamiltonov_ciklus(1)) {
        for (int i = 0; i < n; i++) {
            printf("%d ", put[i] + 1); 
        }
        printf("%d\n", 1); 
    } else {
        printf("-1\n");  
    }

    return 0;
}