#include <iostream>
#include <vector>
#include <stack>
#include <algorithm>
#include <bits/stdc++.h>
using namespace std;

bool** graf;
long* put;
bool* obidjeniCvorovi;
long n;

void povezi(long i, long j, bool** g)
{
    g[i - 1][j - 1] = 1;
    g[j - 1][i - 1] = 1;
}

bool korakNapred(long sledeci, long pozicija)
{
    // moze li dalje
    if (graf[put[pozicija - 1]][sledeci] == 0)
    {
        return false;
    }

    // da li je vec u putu
    for (long i = 0; i < pozicija; ++i)
    {
        if (put[i] == sledeci)
        {
            return false;
        }
    }

    return true;
}

bool pretragaPoDubini(long pozicija)
{

    if (pozicija == n)
    {
        // da li zadnji elemenat u putu pokazuje na prvi
        if (!graf[0][put[n - 1]])
        {
            return false;
        }

        for (long i = 0; i < n; i++)
        {
            cout << put[i] + 1 << " ";
        }
        cout << 1;

        return true;
    }

    for (long sledeci = 1; sledeci < n; sledeci++)
    {
        if (!obidjeniCvorovi[sledeci] && korakNapred(sledeci, pozicija))
        {
            obidjeniCvorovi[sledeci] = true;
            put[pozicija] = sledeci;
            if (pretragaPoDubini(pozicija + 1))
                return true;

            obidjeniCvorovi[sledeci] = false;
            put[pozicija] = -1;
        }
    }

    return false;
}




int main()
{

    cin >> n;
    graf = new bool* [n];
    for (long i = 0; i < n; i++)
    {
        graf[i] = new bool[n];
        memset(graf[i], 0, n);
    }

    povezi(1, 2, graf);
    povezi(1, 3, graf);
    povezi(1, 4, graf);
    povezi(2, 4, graf);

    for (long long i = 5; i <= n; i++)
    {
        long a, b, c;
        cin >> a >> b >> c;

        povezi(i, a, graf);
        povezi(i, b, graf);
        povezi(i, c, graf);
    }

    put = new long[n];
    memset(put, -1, n);

    obidjeniCvorovi = new bool[n];
    memset(obidjeniCvorovi, 0, n);


    obidjeniCvorovi[0] = true;
    put[0] = 0;

    if (!pretragaPoDubini(1))
        cout << -1 << endl;

    return 0;
}