#include <iostream>
#include <vector>
#include <queue>


const int n = 200000;
std::vector<std::vector<int>> adj;

class Graph {
public:
    int V;

    Graph(int V) : V(V) {
        adj.resize(V);
    }

    void dodajivicu(int u, int v) {
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    std::vector<int> hamiltoniancycle() {
        std::vector<int> cycle;
        std::vector<bool> visited(V, false);

        std::priority_queue<std::pair<int, int>, std::vector<std::pair<int, int>>, std::greater<std::pair<int, int>>> pq;

        visited[0] = true;
        cycle.push_back(0);

        int curr = 0;
        for (int i = 1; i < V; i++) {
            pq = std::priority_queue<std::pair<int, int>, std::vector<std::pair<int, int>>, std::greater<std::pair<int, int>>>();

            for (int neighbor : adj[curr]) {
                if (!visited[neighbor]) {
                    pq.push({1, neighbor});
                }
            }

            bool found = false;
            while (!pq.empty()) {
                int next = pq.top().second;
                pq.pop();

                if (!visited[next]) {
                    visited[next] = true;
                    cycle.push_back(next);
                    curr = next;
                    found = true;
                    break;
                }
            }

            if (!found) return {};
        }

        bool zatvaranje = false;
        for (int neighbor : adj[curr]) {
            if (neighbor == cycle[0]) {
                zatvaranje = true;
                break;
            }
        }

        if (zatvaranje) {
            cycle.push_back(cycle[0]);
            return cycle;
        }

        return {};
    }
};

int main() {
    int V;
    std::ios::sync_with_stdio(0);
    std::cin.tie(0);

    std::cin >> V;

    if (V < 3) {
        std::cout << -1 << "\n";
        return 0;
    }

    Graph g(V);

    g.dodajivicu(0, 1);  // 1-2-3
    g.dodajivicu(1, 2);
    g.dodajivicu(2, 0);

    if (V >= 4) {
        g.dodajivicu(0, 3);
        g.dodajivicu(3, 2);
        g.dodajivicu(3, 1);

        for (int i = 4; i < V; ++i) {
            int a, b, c;
            std::cin >> a >> b >> c;
            a--; b--; c--;

            g.dodajivicu(i, a);
            g.dodajivicu(i, b);
            g.dodajivicu(i, c);
        }
    }

    std::vector<int> cycle = g.hamiltoniancycle();

    if (!cycle.empty()) {
        for (int v : cycle) {
            std::cout << v + 1 << " ";
        }
        std::cout << "\n";
    } else {
        std::cout << -1 << "\n";
    }

    return 0;
}