#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

class Graph {
public:
    int V;
    vector<vector<int>> adj;

    Graph(int V) : V(V) {
        adj.resize(V);
    }

    void dodajivice(int u, int v) {
        adj[u].push_back(v);
        adj[v].push_back(u);
    }
};

int f1(const Graph& g, int mask, int pos, vector<vector<int>>& dp, vector<vector<int>>& gl) {
    if (mask == (1 << g.V) - 1) {
        return find(g.adj[pos].begin(), g.adj[pos].end(), 0) != g.adj[pos].end() ? 1 : 0;
    }

    if (dp[mask][pos] != -1) {
        return dp[mask][pos];
    }

    int res = 0;
    int bestprev = -1;

    for (int v = 0; v < g.V; v++) {
        if ((mask & (1 << v)) == 0 && find(g.adj[pos].begin(), g.adj[pos].end(), v) != g.adj[pos].end()) {
            int result = f1(g, mask | (1 << v), v, dp, gl);
            if (result > res) {
                res = result;
                bestprev = v;
            }
        }
    }

    gl[mask][pos] = bestprev;
    return dp[mask][pos] = res;
}

vector<int> hamiltonovciklus(const Graph& g) {
    vector<vector<int>> dp(1 << g.V, vector<int>(g.V, -1));
    vector<vector<int>> glavni(1 << g.V, vector<int>(g.V, -1));

    if (f1(g, 1, 0, dp, glavni)) {
        vector<int> cycle;
        int mask = 1;
        int pos = 0;

        // Reconstruct the cycle
        cycle.push_back(0);
        while (true) {
            int nextpos = glavni[mask][pos];
            if (nextpos == -1) break;
            cycle.push_back(nextpos);
            mask |= (1 << nextpos);
            pos = nextpos;
        }

        cycle.push_back(0);
        return cycle;
    }

    return {};
}

int main() {
    int n;
    std::ios::sync_with_stdio(0);
    std::cin.tie(0);
    cin >> n;

    if (n < 3) {
        cout << -1 << endl;
        return 0;
    }

    Graph g(n);

    g.dodajivice(0, 1);
    g.dodajivice(1, 2);
    g.dodajivice(2, 0);

    g.dodajivice(0, 3);
    g.dodajivice(1, 3);
    g.dodajivice(2, 3);

    for (int i = 4; i < n; i++) {
        int a;
        int b;
        int c;
        cin >> a >> b >> c;
        a--; b--; c--;

        g.dodajivice(a, i);
        g.dodajivice(b, i);
        g.dodajivice(c, i);
    }

    vector<int> cycle = hamiltonovciklus(g);

    if (cycle.empty()) {
        cout << -1 << "\n";
    } else {
        for (int v : cycle) {
            cout << v + 1 << " ";
        }
    }

    return 0;
}