#include <iostream>
#include <vector>
#include <algorithm>
#include <set>

using namespace std;

bool jeHamiltonovCiklus(const vector<vector<int>>& graf, const vector<int>& putanja) {
    for (size_t i = 0; i < putanja.size() - 1; i++) {
        if (find(graf[putanja[i]].begin(), graf[putanja[i]].end(), putanja[i + 1]) == graf[putanja[i]].end()) {
            return false;
        }
    }
    return true;
}

bool pronadjiHamiltonovCiklus(vector<vector<int>>& graf, vector<int>& putanja, vector<bool>& posecen, int trenutni) {
    if (putanja.size() == graf.size() - 1) {
        return find(graf[trenutni].begin(), graf[trenutni].end(), putanja[0]) != graf[trenutni].end();
    }

    for (int sused : graf[trenutni]) {
        if (!posecen[sused]) {
            posecen[sused] = true;
            putanja.push_back(sused);

            if (pronadjiHamiltonovCiklus(graf, putanja, posecen, sused)) {
                return true;
            }

            posecen[sused] = false;
            putanja.pop_back();
        }
    }

    return false;
}

int main() {
    int broj_tacaka;
    cin >> broj_tacaka;

    vector<vector<int>> graf(broj_tacaka + 1);

    graf[1].push_back(2);
    graf[1].push_back(3);
    graf[2].push_back(1);
    graf[2].push_back(3);
    graf[3].push_back(1);
    graf[3].push_back(2);

    graf[4].push_back(1);
    graf[4].push_back(2);
    graf[4].push_back(3);
    graf[1].push_back(4);
    graf[2].push_back(4);
    graf[3].push_back(4);

    vector<vector<int>> trouglovi(broj_tacaka - 4);
    for (int i = 0; i < broj_tacaka - 4; i++) {
        vector<int> trougao(3);
        cin >> trougao[0] >> trougao[1] >> trougao[2];
        trouglovi[i] = trougao;
    }

        for (int i = 1; i < broj_tacaka-4+1; i++) {
            for (int j = 0; j < 3; j++) {
                    graf[i+4].push_back(trouglovi[i-1][j]);
                    graf[trouglovi[i-1][j]].push_back(i+4);
            }
        }

    vector<int> putanja = {1};
    vector<bool> posecen(broj_tacaka + 1, false);
    posecen[1] = true;

    if (pronadjiHamiltonovCiklus(graf, putanja, posecen, 1)) {
        for (int cvor : putanja) {
            cout << cvor << " ";
        }
        cout << putanja[0] << endl;
    };

    return 0;
}