#include <iostream>
#include <vector>
#include <algorithm>
#include <climits>

using namespace std;


// Pomera granice niza tako da se nakon izbora od m-elemenata na krajevima niza
// nalazi najmanji moguci element (ili levo, ili desno)
void trimujJednom(vector<int>& arr, int m, int& levo, int& desno) {
    int preostalaDuzina = desno - levo + 1 - m;
    int minMaxIxOdLevog = 0;
    int minMax = INT_MAX;

    // Klizajuci prozor
    for (int poc = 0; poc <= m; poc++) {
        int kraj = desno + poc - m;

        //cout << "E " << levo + poc << " " << kraj << endl;

        if (kraj > desno) break;

        int maxPocKraj = std::max(arr[levo + poc], arr[kraj]);
        //cout << "Max: " << maxPocKraj << endl;
        if (maxPocKraj < minMax)
        {
            minMaxIxOdLevog = poc;
        }
        else if (maxPocKraj == minMax && levo + minMaxIxOdLevog + 1 < kraj - 1
            && arr[levo + minMaxIxOdLevog + 1] < arr[kraj - 1])
        {
            minMaxIxOdLevog = poc;
        }

        minMax = std::min(minMax, maxPocKraj);

        //cout << "Do sada " << minMaxIxOdLevog << endl;
    }

    levo += minMaxIxOdLevog;
    desno -= (m - minMaxIxOdLevog);
}

// Bira najveci element sa krajeva niza za datog igraca, ukoliko su elementi
// na krajevima jednaki bira onaj ciji je sused manji
void izaberi(vector<int>& arr, vector<long long>& rez, int igrac, int& levo, int& desno)
{
    if (arr[levo] > arr[desno])
    {
        rez[igrac] += arr[levo];
        levo++;
    }
    else if (arr[levo] < arr[desno])
    {
        rez[igrac] += arr[desno];
        desno--;
    }
    else if (arr[levo] == arr[desno])
    {
        if (levo + 1 < desno - 1)
        {
            if (arr[levo + 1] >= arr[desno - 1])
            {
                rez[igrac] += arr[levo];
                levo++;
            }
            else {
                rez[igrac] += arr[desno];
                desno--;
            }
        }
        else {
            rez[igrac] += arr[levo];
            levo++;
        }
    }
}

int main() {
    int n;
    scanf("%d",&n);
    int m;
    scanf("%d",&m);


    // Example input
    vector<int> arr;
    arr.resize(n);
    for (int i = 0; i < n; i++){
        scanf("%d",&arr[i]);
    }

    vector<long long> rez(0);
    rez.resize(m);

    for (int i = 0; i < m; i++)
    {
        //cout << "Igrac " << i << endl;
        int levo = 0;
        int desno = arr.size() - 1;

        // Izbor onih koji igraju pre igraca za kojeg se izvrsava simulacija
        trimujJednom(arr, i, levo, desno);

        //cout << "Nakon inicialnog izbora [" << levo << ", " << desno << "]\n";
        izaberi(arr, rez, i, levo, desno);
        //cout << "Nakon inicialnog izbora [" << levo << ", " << desno << "]\n";

        while (desno - levo + 1 >= m) {
            trimujJednom(arr, m - 1, levo, desno);
            //cout << i << " [" << levo << ", " << desno << "]\n";

            //cout << "Biti " << arr[levo] << " il ne biti " << arr[desno] << endl;
            izaberi(arr, rez, i, levo, desno);
           // cout << i << " nakon [" << levo << ", " << desno << "]\n";
        }
    }

    for (int i = 0; i < rez.size(); i++)
    {
        cout << rez[i] << " ";
    }

    return 0;
}