#include <iostream>
#include <vector>
#include <algorithm>
#include <climits>
using namespace std;
bool daLiJePutValidan(const vector<vector<int>>& graf, const vector<int>& put) {
    for (size_t i = 0; i < put.size() - 1; ++i) {
        if (find(graf[put[i]].begin(), graf[put[i]].end(), put[i + 1]) == graf[put[i]].end()) {
            return false; 
        }
    }
    return true;
}
int main() {
    int brojProdavnica;
    cin >> brojProdavnica;
    vector<vector<int>> graf(brojProdavnica + 1);
    graf[1] = {2, 3};
    graf[2] = {1, 3};
    graf[3] = {1, 2};
    for (int prodavnica = 5; prodavnica <= brojProdavnica; ++prodavnica) {
        int a, b, c;
        cin >> a >> b >> c;
        graf[prodavnica] = {a, b, c};
        graf[a].push_back(prodavnica);
        graf[b].push_back(prodavnica);
        graf[c].push_back(prodavnica);
    }
    vector<int> cvorovi;
    for (int i = 2; i <= brojProdavnica; ++i) {
        cvorovi.push_back(i);
    }
    int minimalnaDuzina = INT_MAX;
    vector<int> najboljiPut;
    do {
        vector<int> put = {1}; 
        put.insert(put.end(), cvorovi.begin(), cvorovi.end());
        put.push_back(1); 
        if (daLiJePutValidan(graf, put)) {
            int duzina = put.size() - 1; 
            if (duzina < minimalnaDuzina) {
                minimalnaDuzina = duzina;
                najboljiPut = put;
            }
        }
    } while (next_permutation(cvorovi.begin(), cvorovi.end()));
    if (najboljiPut.empty()) {
        cout << -1 << endl;
    } else {
        for (int cvor : najboljiPut) {
            cout << cvor << " ";
        }
    }

    return 0;
}