#include<bits/stdc++.h>
#define int long long
using namespace std;

vector<int> poseceni;
vector<int> putanja, snaga;
vector<vector<int>> graf;

void dubinskaPretraga(int cvor) {
    poseceni[cvor] = 1;
    putanja.push_back(cvor);
    int maksimalnaSnaga = 0, sledeciCvor = -1;
    for (int& sused : graf[cvor]) {
        if (!poseceni[sused]) {
            if (maksimalnaSnaga < snaga[sused]) {
                maksimalnaSnaga = snaga[sused];
                sledeciCvor = sused;
            }
        }
    }
    if (sledeciCvor != -1) {
        dubinskaPretraga(sledeciCvor);
    }
}

void dodajGranu(int a, int b) {
    graf[a].push_back(b);
    graf[b].push_back(a);
}

void resi() {
    int brojCvorova;
    cin >> brojCvorova;
    poseceni.resize(brojCvorova + 1);
    graf.resize(brojCvorova + 1);
    snaga.resize(brojCvorova + 1);
    
    dodajGranu(1, 2);
    dodajGranu(1, 3);
    dodajGranu(2, 3);
    dodajGranu(1, 4);
    dodajGranu(2, 4);
    dodajGranu(3, 4);
    snaga[1] = snaga[2] = snaga[3] = 1;
    snaga[4] = 2;
    
    for (int i = 5; i <= brojCvorova; i++) {
        int a, b, c;
        cin >> a >> b >> c;
        int maksimalnaSnaga = max({snaga[a], snaga[b], snaga[c]});
        dodajGranu(i, a);
        dodajGranu(i, b);
        dodajGranu(i, c);
        snaga[i] = maksimalnaSnaga + 1;
    }
    
    dubinskaPretraga(1);
    bool povratakNaPocetak = 0;
    for (int& sused : graf[putanja[putanja.size() - 1]]) {
        povratakNaPocetak |= (sused == 1);
    }
    if (!povratakNaPocetak || putanja.size() != brojCvorova) {
        cout << -1 << '\n';
        return;
    }
    for (int& cvor : putanja) {
        cout << cvor << ' ';
    }
    cout << 1 << '\n';
}

int32_t main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    
    int32_t brojTestova = 1;
    while (brojTestova--) {
        resi();
    }
    return 0;
}