#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

vector<vector<int>> graph;
vector<bool> visited;
vector<int> path;

bool dfs(int node, int n, int count) {
    visited[node] = true;
    path.push_back(node);

    if (count == n) {
        if (find(graph[node].begin(), graph[node].end(), 1) != graph[node].end()) {
            path.push_back(1);
            return true;
        }
    } else {
        for (int neighbor : graph[node]) {
            if (!visited[neighbor]) {
                if (dfs(neighbor, n, count + 1)) {
                    return true;
                }
            }
        }
    }
    
    visited[node] = false;
    path.pop_back();
    return false;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0),cout.tie(0);
    
    int n;
    cin >> n;

    graph.resize(n + 1);
    visited.resize(n + 1, false);

    for (int i = 1; i <= n; i++) {
        if (i == 1) {
            graph[1].push_back(2);
            graph[2].push_back(1);
            graph[1].push_back(3);
            graph[3].push_back(1);
            graph[2].push_back(3);
            graph[3].push_back(2);
        } else {
            int a, b, c;
            cin >> a >> b >> c;
            graph[i].push_back(a);
            graph[i].push_back(b);
            graph[i].push_back(c);
            graph[a].push_back(i);
            graph[b].push_back(i);
            graph[c].push_back(i);
        }
    }

    if (dfs(1, n, 1)) {
        for (int i : path) {
            cout << i << " ";
        }
        cout << endl;
    } else {
        cout << -1 << endl;
    }

    return 0;
}