#include <iostream>
#include <algorithm>
#include <vector>
#include <cmath>

using namespace std;

long long solve(int i, int j, vector<int>&arr, int player, vector<vector<int>>& dp) {
	if (i > j) {
		return 0;
	}

	if (dp[i][j] != -1) {
		return dp[i][j];
	}

	if (player == 0) {
		int c1 = arr[i] + solve(i + 1, j, arr, 1, dp);
		int c2 = arr[j] + solve(i, j - 1, arr, 1, dp);
		return dp[i][j] = max(c1, c2);
	}
	else {
		int c1 = solve(i + 1, j, arr, 0, dp);
		int c2 = solve(i, j - 1, arr, 0, dp);
		return dp[i][j] = min(c1, c2);
	}
}


int main() {
	ios::sync_with_stdio(false);
	cin.tie(nullptr);
	cout.tie(nullptr);

	int n, m; cin >> n >> m;
	vector<int> arr(n);
	int sum = 0;

	for (int i = 0; i < n; i++) {
		cin >> arr[i];
		sum += arr[i];
	}

	vector<vector<int>> dp(n, vector<int>(n, -1));
	cout << solve(0, n - 1, arr, 0, dp) << " " << sum - solve(0, n - 1, arr, 0, dp) << endl;

    return 0;
}