#include <iostream>
#include <set>
#include <vector>
using namespace std;

// Neighbors are ordered according to their nesting level.
typedef vector<set<tuple<int, int>>> Graph;

void printSolution(vector<int> &path) {
    if (path.size() == 1)
        cout << -1;
    else {
        for (int store : path)
            cout << store << " ";
        cout << 1;
    }
    cout << endl;
}

bool solve(int n, Graph &g, int store, vector<int> &path, vector<bool> &active) {
    active[store] = true;
    path.push_back(store);

    // Do we have a solution?
    if (path.size() == n and g[path.back()].find({0, 1}) != g[path.back()].cend())
        return true;

    for (auto [_, neighbor] : g[store])
        if (!active[neighbor] and solve(n, g, neighbor, path, active))
            return true;

    path.pop_back();
    active[store] = false;
    return false;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    int n;
    cin >> n;

    // Denotes the nesting level of a point inside some triangle.
    vector<int> depth(n + 1);
    Graph g(n + 1);
    g[1].insert({0, 2}), g[1].insert({0, 3}), g[1].insert({-1, 4});
    g[2].insert({0, 1}), g[2].insert({0, 3}), g[2].insert({-1, 4});
    g[3].insert({0, 1}), g[3].insert({0, 2}), g[3].insert({-1, 4});
    g[4].insert({0, 1}), g[4].insert({0, 2}), g[4].insert({0, 3});
    depth[4] = -1;

    for (int i = 5; i <= n; i++) {
        int a, b, c;
        cin >> a >> b >> c;
        depth[i] = min(min(depth[a], depth[b]), depth[c]) - 1;
        g[a].insert({depth[i], i}), g[b].insert({depth[i], i}), g[c].insert({depth[i], i});
        g[i].insert({depth[a], a}), g[i].insert({depth[b], b}), g[i].insert({depth[c], c});
    }

    vector<int> path;
    path.reserve(n);
    // Flags whether any store is on the active search path.
    vector<bool> active(n + 1);
    solve(n, g, 1, path, active);
    printSolution(path);

    return 0;
}