#include <iostream>
#include <vector>
#include <algorithm>
#include <list>
using namespace std;

// Function to print the solution
void printSolution(int path[], int n) {

    for (int i = 0; i < n; i++)
        cout << path[i] + 1 << " "; 
    cout << path[0] + 1 << " "; 
    cout << endl;
}


bool isSafe(int v, vector<list<int>>& graph, int path[], int pos) {

    if (find(graph[path[pos - 1]].begin(), graph[path[pos - 1]].end(), v) == graph[path[pos - 1]].end())
        return false;


    for (int i = 0; i < pos; i++)
        if (path[i] == v)
            return false;

    return true;
}


bool hamCycleUtil(vector<list<int>>& graph, int path[], int pos, int n) {
   
    if (pos == n) {
        
        if (find(graph[path[pos - 1]].begin(), graph[path[pos - 1]].end(), path[0]) != graph[path[pos - 1]].end())
            return true;
        else
            return false;
    }


    for (int v = 1; v < n; v++) {
        if (isSafe(v, graph, path, pos)) {
            path[pos] = v;

            if (hamCycleUtil(graph, path, pos + 1, n) == true)
                return true;

            path[pos] = -1;
        }
    }


    return false;
}


bool hamCycle(vector<list<int>>& graph, int n) {
    int* path = new int[n];
    for (int i = 0; i < n; i++)
        path[i] = -1;


    path[0] = 0;
    if (hamCycleUtil(graph, path, 1, n) == false) {
        cout << "-1";
        return false;
    }

    printSolution(path, n);
    return true;
}

int main() {
    int n;
    cin >> n;


    vector<list<int>> graph(n);


    graph[0].push_back(1);
    graph[0].push_back(2);
    graph[0].push_back(3);
    graph[1].push_back(0);
    graph[1].push_back(2);
    graph[1].push_back(3);
    graph[2].push_back(0);
    graph[2].push_back(1);
    graph[2].push_back(3);
    graph[3].push_back(0);
    graph[3].push_back(1);
    graph[3].push_back(2);


    for (int i = 4; i < n; ++i) {
        int a, b, c;
        cin >> a >> b >> c;
        a--; b--; c--; 

        graph[i].push_back(a);
        graph[i].push_back(b);
        graph[i].push_back(c);
        graph[a].push_back(i);
        graph[b].push_back(i);
        graph[c].push_back(i);
    }

    hamCycle(graph, n);

    return 0;
}