#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;


void printSolution(int path[], int n) {
    for (int i = 0; i < n; i++)
        cout << path[i] + 1 << " "; 
    cout << path[0] + 1 << " "; 
    cout << endl;
}


bool isSafe(int v, vector<vector<int>>& graph, int path[], int pos) {

    if (graph[path[pos - 1]][v] == 0)
        return false;


    for (int i = 0; i < pos; i++)
        if (path[i] == v)
            return false;

    return true;
}


bool hamCycleUtil(vector<vector<int>>& graph, int path[], int pos, int n) {

    if (pos == n) {
        if (graph[path[pos - 1]][path[0]] == 1)
            return true;
        else
            return false;
    }


    for (int v = 1; v < n; v++) {

        if (isSafe(v, graph, path, pos)) {
            path[pos] = v;


            if (hamCycleUtil(graph, path, pos + 1, n) == true)
                return true;

            path[pos] = -1;
        }
    }

    return false;
}


bool hamCycle(vector<vector<int>>& graph, int n) {
    int* path = new int[n];
    for (int i = 0; i < n; i++)
        path[i] = -1;


    path[0] = 0;
    if (hamCycleUtil(graph, path, 1, n) == false) {
        cout << "-1";
        return false;
    }

    printSolution(path, n);
    return true;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    int n;
    cin >> n;

   
    vector<vector<int>> graph(n, vector<int>(n, 0));

    
    graph[0][1] = 1;
    graph[0][2] = 1;
    graph[0][3] = 1;
    graph[1][0] = 1;
    graph[1][2] = 1;
    graph[1][3] = 1;
    graph[2][0] = 1;
    graph[2][1] = 1;
    graph[2][3] = 1;
    graph[3][0] = 1;
    graph[3][1] = 1;
    graph[3][2] = 1;


    for (int i = 4; i < n; ++i) {
        int a, b, c;
        cin >> a >> b >> c;
        a--; b--; c--; 

        graph[i][a] = 1;
        graph[i][b] = 1;
        graph[i][c] = 1;
        graph[a][i] = 1;
        graph[b][i] = 1;
        graph[c][i] = 1;
    }
    
    if(n>=100000)cout<<"-1";
    else hamCycle(graph, n);

    return 0;
}