#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_N 100001

typedef struct {
    long long sum;
    int lnaj, dnaj;
    int levo_id, desno_id;
} SegmentNode;

SegmentNode stablo[4 * MAX_N];
int nfts[MAX_N];
int N, M;

void build(int node, int pocetak, int kraj)
{
    if (pocetak == kraj)
    {
        stablo[node].sum = nfts[pocetak];
        stablo[node].lnaj = stablo[node].dnaj = nfts[pocetak];
        stablo[node].levo_id = stablo[node].desno_id = pocetak;
        return;
    }
    int mid = (pocetak + kraj) / 2;
    build(2 * node, pocetak, mid);
    build(2 * node + 1, mid + 1, kraj);
    stablo[node].sum = stablo[2 * node].sum + stablo[2 * node + 1].sum;
    if (stablo[2 * node].lnaj > stablo[2 * node + 1].lnaj)
    {
        stablo[node].lnaj = stablo[2 * node].lnaj;
        stablo[node].levo_id = stablo[2 * node].levo_id;
    }
    else
    {
        stablo[node].lnaj = stablo[2 * node + 1].lnaj;
        stablo[node].levo_id = stablo[2 * node + 1].levo_id;
    }

    if (stablo[2 * node].dnaj > stablo[2 * node + 1].dnaj)
    {
        stablo[node].dnaj = stablo[2 * node].dnaj;
        stablo[node].desno_id = stablo[2 * node].desno_id;
    }
    else
    {
        stablo[node].dnaj = stablo[2 * node + 1].dnaj;
        stablo[node].desno_id = stablo[2 * node + 1].desno_id;
    }
}

long long query_sum(int node, int pocetak, int kraj, int l, int r) {
    if (r < pocetak || l > kraj) return 0;
    if (l <= pocetak && kraj <= r) return stablo[node].sum;
    int mid = (pocetak + kraj) / 2;
    return query_sum(2 * node, pocetak, mid, l, r) + query_sum(2 * node + 1, mid + 1, kraj, l, r);
}

int najbolji(int node, int pocetak, int kraj, int l, int r, int levlje) {
    if (r < pocetak || l > kraj) return -1;
    if (l <= pocetak && kraj <= r) {
        return levlje ? stablo[node].levo_id : stablo[node].desno_id;
    }

    int mid = (pocetak + kraj) / 2;
    int idx1 = najbolji(2 * node, pocetak, mid, l, r, levlje);
    int idx2 = najbolji(2 * node + 1, mid + 1, kraj, l, r, levlje);
    if (idx1 == -1) return idx2;
    if (idx2 == -1) return idx1;
    if (levlje)
    {
        return nfts[idx1] > nfts[idx2] ? idx1 : idx2;
    }
    else
    {
        return nfts[idx1] > nfts[idx2] ? idx1 : idx2;
    }
}

long long resi(int levo, int desno, int tekuci, int neki)
{
    if (levo > desno) return 0;
    if (tekuci == neki)
    {
        long long uzmi_levo = nfts[levo] + resi(levo + 1, desno, (tekuci + 1) % M, neki);
        long long uzmi_desno = nfts[desno] + resi(levo, desno - 1, (tekuci + 1) % M, neki);

        return uzmi_levo > uzmi_desno ? uzmi_levo : uzmi_desno;
    }
    else
    {
        long long uzmi_levo = resi(levo + 1, desno, (tekuci + 1) % M, neki);
        long long uzmi_desno = resi(levo, desno - 1, (tekuci + 1) % M, neki);

        return uzmi_levo < uzmi_desno ? uzmi_levo : uzmi_desno;
    }
}

int main()
{
    scanf("%d %d", &N, &M);
    for (int i = 0; i < N; i++)
    {
        scanf("%d", &nfts[i]);
    }
    build(1, 0, N-1);
    for (int i = 0; i < M; i++)
    {
        long long profit = resi(0, N-1, 0, i);
        printf("%lld", profit);
        if (i < M-1) printf(" ");
    }
    printf("\n");
    return 0;
}