#include <bits/stdc++.h>
using namespace std;

// Loops
#define FOR(n)              for(int i=0;i<n;i++)
#define FORJ(n)             for(int j=0;j<n;j++)
#define FORN(n,x)           for(int x=0;i<n;i++)
#define RFOR(n)             for(int i=n-1;i>=0;i--)
#define RFORN(n,x)          for(int x=n-1;x>=0;x--)
#define ODD_FOR(n)          for(int i=1;i<n;i+=2)
#define EVEN_FOR(n)         for(int i=2;i<n;i+=2)
#define FROM(n,m)           for(int i=n;i<m;i++)
#define FROMJ(n,m)          for(int j=n;j<m;j++)
#define RFROM(n,m)          for(int i=n-1;i>=m;i--)
#define RFROMJ(n,m)         for(int j=n-1;j>=m;j--)
#define STL_FOR(a)          for(auto i=a.begin();i!=a.end();i++)
#define STL_FORJ(a)         for(auto j=a.begin();j!=a.end();j++)
#define STL_FORN(a,x)       for(auto x=a.begin();x!=a.end();x++)
#define STL_FROM(a,n,m)     for(auto i=n;i!=m;i++)
#define STL_FROMJ(n,m)      for(auto j=n;j!=m;j++)
#define RSTL_FOR(a)         for(auto i=a.rbegin();i!=a.rend();i++)
#define RSTL_FORJ(a)        for(auto j=a.rbegin();j!=a.rend();j++)

// Types
#define ll             long long int
#define vec                   vector
#define veci             vector<int>
#define pb                 push_back
#define pf                push_front
#define fi                     first
#define se                    second
#define umap           unordered_map
#define ummap     unordered_multimap
#define mmap                multimap
#define mset                multiset
#define uset           unordered_set
#define umset     unordered_multiset
#define endl                    '\n'
#define all(a)    a.begin(), a.end()

// I/O
void read() {}
template<typename type, typename... types>
void read(type& arg, types&... args) { cin >> arg; read(args...); }

void write() { cout << endl; }
template<typename type, typename... types>
void write(type arg, types... args) { cout << arg << ' '; write(args...); }

#define dbg(x) cerr<<#x<<" = "<<x<<endl;

const int M = 200'000+1;

int depth[M]={};

struct graph {
    int n, m;
    list<int>* adj;

    graph(int n, int m) :
        n(n), m(m)
    {
        adj = new list<int>[n + 1];
    }
    ~graph() {delete[] adj;}

    void add_edge(int node, int edge) {
        adj[node].push_back(edge);
        adj[edge].push_back(node);
    }

    friend istream& operator>> (istream& in, graph& g) {
        int node, edge;
        for (int i = 0; i < g.m; i++) {
            in >> node >> edge;
            g.add_edge(node, edge);
        }
        return in;
    }


    void find_path(int s) {

        vector<int> ans;
        ans.reserve(n);

        bool seen[n+1]={0};

        seen[s]=1;

        while(s) {
            seen[s]=true;
            ans.push_back(s);

            int m = 0;
            for( const int& x : adj[s]) {
                //cout<<x<<' ';
                if(!seen[x] && depth[x]>depth[m])
                    m=x;
            }
            s = m;

        }

        if(ans.size()!=n || find(adj[ans.back()].begin(), adj[ans.back()].end(), 1) == adj[ans.back()].end()) {
            cout<<-1;
            return;
        }

        //cout<<ans.size();
        FOR(n) cout<<ans[i]<<' ';
        cout<<1<<endl;
    }
};


int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    depth[0]=-1;
    depth[1]=0;
    depth[2]=0;
    depth[3]=0;
    depth[4]=1;

    int n, m;
    cin>>n;
    m = (n-2)*3;

    graph g(n, m);

    g.add_edge(1, 2);
    g.add_edge(1, 3);
    g.add_edge(1, 4);
    g.add_edge(2, 3);
    g.add_edge(2, 4);
    g.add_edge(3, 4);

    int a, b, c;
    int x = 5;
    FOR(n-4) {
        cin>>a>>b>>c;

        g.add_edge(a, x);
        g.add_edge(b, x);
        g.add_edge(c, x);

        depth[x] = max(depth[a], max(depth[b], depth[c])) + 1;
        x++;
    }

    g.find_path(1);
}

/*
8
1 3 4
3 4 5
1 5 3
1 2 4
*/