using System;
namespace Putesetvije
{
    public class HamiltonCycle
    {   
        int _n;
        int[,] _veze;
        int[] _path;

        public HamiltonCycle(int n, int[,] veze)
        {
            _n = n;
            _veze = veze;
        }

        bool IsSafe(int v, int[,] veze, int[] path, int pos)
        {
            if (veze[path[pos - 1], v] == 0)
            {
                return false;
            }
            for (int i = 0; i < pos; i++)
            {
                if (path[i] == v)
                {
                    return false;
                }
            }
            return true;
        }

        bool HamCycleUtil(int[,] veze, int[] path, int pos)
        {
            if (pos == _n)
            {
                if (veze[path[pos - 1], path[0]] == 1) return true;
                else return false;
            }
            for (int v = 1; v < _n; v++)
            {
                if (IsSafe(v, veze, path, pos))
                {
                    path[pos] = v;
                    if (HamCycleUtil(veze, path, pos + 1) == true)
                    {
                        return true;
                    }
                    path[pos] = -1;

                }
            }
            return false;
        }

        public void HamCycle(int[,] veze)
        {
            _path = new int[_n];
            for (int i = 0; i < _n; i++)
            {
                _path[i] = -1;
            }
            _path[0] = 0;
            if (HamCycleUtil(veze, _path, 1) == false)
            {
                Console.WriteLine(-1);
            }
            else
            {
                PrintSolution(_path);
            }
        }

        void PrintSolution(int[] path)
        {
            for(int i = 0; i < _n; i++)
            {
                Console.Write(path[i] + 1 + " ");
            }
            Console.Write(path[0] + 1);
        }
    }

    internal class Program
    {
        static void UnosPodatak(out int n, out int[,] veze)
        {
            n = int.Parse(Console.ReadLine());
            veze = new int[n, n];
            for (int i = 0; i < 4; i++)
            {
                for (int j = 0; j < 4; j++)
                {
                    veze[i, j] = 1;
                    veze[j, i] = 1;
                }
            }
            for (int novaProdavnica = 4; novaProdavnica < n; novaProdavnica++)
            {
                int[] input = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);
                int x = input[0]; int y = input[1]; int z = input[2];
                veze[novaProdavnica, x - 1] = 1;
                veze[novaProdavnica, y - 1] = 1;
                veze[novaProdavnica, z - 1] = 1;
                veze[x - 1, novaProdavnica] = 1;
                veze[y - 1, novaProdavnica] = 1;
                veze[z - 1, novaProdavnica] = 1;
            }
            for(int i = 0; i < n; i++)
            {
                for(int j = 0;j < n; j++)
                {
                    Console.Write(veze[i, j] + " ");
                }
                Console.WriteLine();
            }
        }
        static void Main(string[] args)
        {
            UnosPodatak(out int n, out int[,] veze);
            HamiltonCycle h = new HamiltonCycle(n, veze);
            h.HamCycle(veze);
        }
    }
}