#include <bits/stdc++.h>

using namespace std;

#define int ll
typedef long long ll;
typedef long double ld;
typedef pair<int, int> pi;
typedef pair<ll, ll> pl;
typedef vector<int> vi;
typedef vector<ll> vl;
typedef vector<double> vd;
typedef vector<bool> vb;
typedef vector<char> vc;
typedef vector<string> vs;
typedef vector<pi> vp;
typedef vector<pl> vpl;

const ld PI = 4.0*atan(1.0);

struct pt{
    ld x;
    ld y;

    friend ostream& operator<<(ostream& os, const pt& p) {
        return os << "(" << p.x << ", " << p.y << ")";
    }
};


double cross(const pt& O, const pt& A, const pt& B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

ld sq(ld x){
    return x*x;
}

ld sq_dist(pt a, pt b){
    return sq(a.x-b.x) + sq(a.y-b.y);
}

pair<pt, ld> centar(const pt& A, const pt& B, const pt& C) {
    ld D = 2 * (A.x * (B.y - C.y) + B.x * (C.y - A.y) + C.x * (A.y - B.y));

    ld Ux = ((A.x * A.x + A.y * A.y) * (B.y - C.y) +
             (B.x * B.x + B.y * B.y) * (C.y - A.y) +
             (C.x * C.x + C.y * C.y) * (A.y - B.y)) / D;

    ld Uy = ((A.x * A.x + A.y * A.y) * (C.x - B.x) +
             (B.x * B.x + B.y * B.y) * (A.x - C.x) +
             (C.x * C.x + C.y * C.y) * (B.x - A.x)) / D;

    pt center = {Ux, Uy};
    ld radius = ((center.x - A.x) * (center.x - A.x) + (center.y - A.y) * (center.y - A.y));

    return {center, radius};
}

int n, m;
vector<pt> blue, red;

void cw(){
    if (cross(blue[0], blue[1], blue[2]) > 0) {
        swap(blue[1], blue[2]);
    }
}

void movex(const pt& A, const pt& B) {
    pt mid = {(A.x + B.x) / 2, (A.y + B.y) / 2};
    for (auto& p : red) {
        p.x -= mid.x;
        p.y -= mid.y;
    }
    for (auto& p : blue) {
        p.x -= mid.x;
        p.y -= mid.y;
    }
}
void rotate(const pt& A, const pt& B) {
    ld angle = atan2(B.y - A.y, B.x - A.x);
    ld rotate_angle = PI/2 - angle; // rotate so AB becomes vertical

    for (auto& p : blue) {
        ld x_shifted = p.x - A.x;
        ld y_shifted = p.y - A.y;

        ld x_new = cos(rotate_angle) * x_shifted - sin(rotate_angle) * y_shifted;
        ld y_new = sin(rotate_angle) * x_shifted + cos(rotate_angle) * y_shifted;

        p.x = x_new;
        p.y = y_new;
    }

    for (auto& p : red) {
        ld x_shifted = p.x - A.x;
        ld y_shifted = p.y - A.y;

        ld x_new = cos(rotate_angle) * x_shifted - sin(rotate_angle) * y_shifted;
        ld y_new = sin(rotate_angle) * x_shifted + cos(rotate_angle) * y_shifted;

        p.x = x_new;
        p.y = y_new;
    }
}

const ld inf = INT32_MAX;

int solve2(int ind){
    
    pt a = blue[ind];
    pt b = blue[(ind+1+90)%3];
    pt c = blue[(ind+2+90)%3];

    rotate(a, b);
    a = blue[ind];
    b = blue[(ind+1+90)%3];
    c = blue[(ind+2+90)%3];

    
    movex(a, b);

    a = blue[ind];
    b = blue[(ind+1+90)%3];
    c = blue[(ind+2+90)%3];

    

    vd vals(n, 0);
    auto cr = centar(a,b,c);
    ld rval = (sq(a.x) + sq(a.y) - sq(c.x) - sq(c.y))/(2*(a.x-c.x));
    

    //-1 znaci levo
    int rz = -1;

    if (a.x - c.x < 0)
        rz = 1;
        
    vector<pair<ld, int>> t;
    
    int cnt = 0;
    for (int i = 0; i < n; ++i){
        vals[i] = (sq(a.x) + sq(a.y) - sq(red[i].x) - sq(red[i].y))/(2*(a.x-red[i].x));

        int z = -1;
        if (a.x-red[i].x < 0)
            z = 1;


        if (z * rz == -1){
            t.push_back({vals[i], z});
            if (z == -1) ++cnt;
        }
        else if (z == 1){

            if (vals[i] < rval){
                t.push_back({vals[i],z});
            }
        } else {
            if (vals[i] > rval){
                ++cnt;
                t.push_back({vals[i],z});
            }
        }
    }

    sort(t.begin(), t.end());

    int sol = 0;

    for (int i = 0; i < t.size(); ++i){
        if (t[i].second == -1)
            --cnt;
        else
            ++cnt;

        sol = max(sol, cnt);
    }

    return sol;
}

bool unutra(const pt& A, const pt& B, const pt& C, const pt& P) {
    ld cross1 = cross(A, B, P);
    ld cross2 = cross(A, P, C);
    ld crossAC = cross(A, B, C);

    if (crossAC >= 0) {
        return cross1 >= 0 && cross2 >= 0;
    } else {
        return cross1 <= 0 && cross2 <= 0;
    }
}

ld angle(const pt& A, const pt& B, const pt& C) {
    pt BA = {A.x - B.x, A.y - B.y};
    pt BC = {C.x - B.x, C.y - B.y};

    ld dot_product = BA.x * BC.x + BA.y * BC.y;
    ld norm_BA = sqrt(BA.x * BA.x + BA.y * BA.y);
    ld norm_BC = sqrt(BC.x * BC.x + BC.y * BC.y);

    return acos(dot_product / (norm_BA * norm_BC));
}

bool seku(const pt& A, const pt& B, const pt& C, const pt& D) {
    pt dir = {D.x - C.x, D.y - C.y};

    pt normal = {-dir.y, dir.x};

    ld sideA = (A.x - C.x) * normal.x + (A.y - C.y) * normal.y;
    ld sideB = (B.x - C.x) * normal.x + (B.y - C.y) * normal.y;

    if (sideA * sideB > 0) return false; 

    ld denom = (B.x - A.x) * normal.x + (B.y - A.y) * normal.y;
    if (abs(denom) < 1e-12) return false;

    ld t = ((C.x - A.x) * normal.x + (C.y - A.y) * normal.y) / denom;

    if (t < 0 || t > 1) return false; 

    pt intersection = {
        A.x + (B.x - A.x) * t,
        A.y + (B.y - A.y) * t
    };

    ld along_ray = (intersection.x - C.x) * dir.x + (intersection.y - C.y) * dir.y;

    return along_ray >= 0;
}

ld angle_from_base(const pt& A, const pt& B, const pt& R) {
    ld dx = B.x - A.x;
    ld dy = B.y - A.y;

    ld vx = R.x - A.x;
    ld vy = R.y - A.y;

    ld cross = dx * vy - dy * vx;
    ld dot = dx * vx + dy * vy;

    ld angle = atan2l(cross, dot);
    if (angle < 0)
        angle += 2 * PI;
    return angle;
}

int tmpc;
int solve3(pt a, pt b, pt c){
    ++tmpc;

    vector<pair<ld,int>> angles;
    for (int i = 0; i < n; ++i){
        pt p = red[i];

        if (unutra(a,b,c,p)) continue;

        angles.push_back({angle_from_base(a,b,p), i});
     //   cout << "ANGLE " << p << ' ' << angle_from_base(a,b,p) << '\n';
    }

    sort(angles.begin(), angles.end());
    //cout << (int)angles.size() << "---";

    int l = 0, r = 0, sol = 0, len = angles.size();
    while(r < len){

       // cout << "TESTIRAM " << seku(red[angles[l].second],red[angles[r].second], a, b) << ' ';
        //cout << l << ' ' << r << ' ' << red[angles[l].second] << ' ' << red[angles[r].second] << ' ';
        //cout << a << ' ' << b << '\n';
        while(seku(red[angles[l].second],red[angles[r].second], a, b) || seku(red[angles[l].second],red[angles[r].second], a, c)){
            ++l;
        }

        sol = max(sol, r-l+1);
        ++r;
    }

    return sol;
}

signed main()
{
    ios_base::sync_with_stdio(false); 
    cin.tie(nullptr); 
    cout.tie(nullptr); 
    cerr.tie(nullptr); 

    int test;
    cin >> test;

    while(test--){

    cin >> n;
    m=3;

    blue = vector<pt>(m);
    for(auto& i : blue)
        cin >> i.x >> i.y;

    cw();

    red = vector<pt>(n);
    for(auto& i : red)
        cin >> i.x >> i.y;

    auto cr = centar(blue[0], blue[1], blue[2]);
    auto c = cr.first;
    auto r = cr.second;

    int cnt = 0, sol = 0;
    for (pt p : red){
        if (sq_dist(p,c) <= r){
            ++cnt;
        }
    }

    sol = cnt;
    //cout << sol << '\n';

    for (int i = 0; i < m; ++i){
        int res = solve3(blue[i], blue[(i-1+90)%3], blue[(i-2+90)%3]);
        sol = max(sol, res);

     //   cout << res << ' ';
    }


    for (int i = 0; i < m; ++i){
        int res = solve2(i);
        sol = max(sol, res);
   //     cout << res << ' ';
    }
    cout << sol << '\n';
}
}