#include <bits/stdc++.h>

using namespace std;

const int MAX_N = 200100;

long double n,T;
pair<long double,long double> srb[5];
pair<long double,long double> dot[MAX_N];

struct Circle
{
    long double a;
    long double b;
    long double r;
};

Circle getCircleFromPoints(pair<long double,long double> d1,
                           pair<long double,long double> d2,
                           pair<long double,long double> d3)
{
    long double x1 = d1.first;
    long double x2 = d2.first;
    long double x3 = d3.first;
    long double y1 = d1.second;
    long double y2 = d2.second;
    long double y3 = d3.second;


    long double D = 2*(x1*(y2-y3)
                        + x2*(y3-y1)
                        + x3*(y1-y2));

    long double x1sq = x1*x1, y1sq = y1*y1;
    long double x2sq = x2*x2, y2sq = y2*y2;
    long double x3sq = x3*x3, y3sq = y3*y3;

    long double a = ( x1sq+y1sq )*(y2-y3)
                  + ( x2sq+y2sq )*(y3-y1)
                  + ( x3sq+y3sq )*(y1-y2);
    a /= D;

    long double b = ( x1sq+y1sq )*(x3-x2)
                  + ( x2sq+y2sq )*(x1-x3)
                  + ( x3sq+y3sq )*(x2-x1);
    b /= D;

    long double r = sqrt((x1-a)*(x1-a)
                       + (y1-b)*(y1-b));

    return {a,b,r};
}

int countInside(const Circle c, pair<long double,long double> exp, bool check)
{
    long double r2 = c.r * c.r;

    if(check)
    {

        // check excluded point first
        long double expx = exp.first  - c.a;
        long double expy = exp.second - c.b;
        if(expx*expx + expy*expy <= r2)
        {
            return 0;
        }
    }

    int rez = 0;
    for(int i=0; i<n;i++)
    {
        long double dx = dot[i].first  - c.a;
        long double dy = dot[i].second - c.b;
        if(dx*dx + dy*dy <= r2)
        {
            rez++;
        }
    }
    return rez;
}

int main()
{
    // Ulaz
    cin>>T;
    for(int t=0;t<T;t++)
    {
        cin>>n;

        // Srb
        for(int i=0;i<3;i++)
        {
            long double x,y;
            cin>>x>>y;
            srb[i].first = x;
            srb[i].second = y;
        }

        // Ostali
        for(int i=0;i<n;i++)
        {
            long double x,y;
            cin>>x>>y;
            dot[i].first = x;
            dot[i].second = y;
        }

        Circle c = getCircleFromPoints(srb[0],srb[1],srb[2]);
        int rez = countInside(c, srb[0], false);

        for(int i=0;i<n;i++)
        {
            Circle c1 = getCircleFromPoints(srb[0],srb[1],dot[i]);
            Circle c2 = getCircleFromPoints(srb[0],srb[2],dot[i]);
            Circle c3 = getCircleFromPoints(srb[1],srb[2],dot[i]);

            rez = max(rez, countInside(c1, srb[2], true));
            rez = max(rez, countInside(c2, srb[1], true));
            rez = max(rez, countInside(c3, srb[0], true));
        }

        cout<<rez<<endl;
    }
    return 0;
}