#include <bits/stdc++.h>

using namespace std;

using ld = long double;

struct Point{
    ld x, y;
};

inline ld sq(ld a)
{
    return a*a;
}

Point circumcenter(Point A, Point B,Point C)
{
    ld D = 2*( A.x*(B.y - C.y)
             +B.x*(C.y - A.y)
             +C.x*(A.y - B.y));

    ld a2 = sq(A.x)+sq(A.y);
    ld b2 = sq(B.x)+sq(B.y);
    ld c2 = sq(C.x)+sq(C.y);

    ld Ux = (a2*(B.y - C.y)
            +b2*(C.y - A.y)
            +c2*(A.y - B.y))/D;
    ld Uy = (a2*(C.x - B.x)
            +b2*(A.x - C.x)
            +c2*(B.x - A.x))/D;

    return {Ux, Uy};
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;
    for(int t=0;t<T;t++)
    {
        int n;
        cin >> n;

        vector<Point>srb(3);
        for(int i=0;i<3;i++)
        {
            cin>>srb[i].x>>srb[i].y;
        }

        vector<Point>R(n);
        for(int i=0;i<n;i++)
        {
            cin >> R[i].x >> R[i].y;
        }

        int answer = 0;
        // 3 plave
        {
            Point O = circumcenter(srb[0], srb[1], srb[2]);
            ld r2 = sq(R[0].x - O.x);
            r2 = sq(srb[0].x - O.x) + sq(srb[0].y - O.y);
            int cnt = 0;

            for(auto &p:R)
            {
                ld d2 = sq(p.x - O.x) + sq(p.y - O.y);
                if(d2 <= r2 + 1e-15L) cnt++;
            }

            answer = max(answer, cnt);
        }

        // 2 plave
        for(int i=0;i<3;i++)
        {
            for(int k=i+1;k<3;k++)
            {
                int m = 3 - i - k;

                Point M{(srb[i].x + srb[k].x)*0.5L,(srb[i].y + srb[k].y)*0.5L};

                ld dx = srb[k].x - srb[i].x;
                ld dy = srb[k].y - srb[i].y;
                Point u{ dy, -dx };

                vector<pair<ld,int>> ev;
                ev.reserve(n);
                int cnt0 = 0;

                for(auto &p:R)
                {
                    ld denom = u.x*(p.x - srb[i].x)
                              +u.y*(p.y - srb[i].y);

                    ld N = (sq(M.x - p.x) + sq(M.y - p.y))
                         - (sq(M.x - srb[i].x) + sq(M.y - srb[i].y));

                    ld tj = N / (2*denom);
                    int tp = (denom > 0 ? +1 : -1);
                    ev.emplace_back(tj, tp);
                    if(denom < 0) cnt0++;
                }

                sort(ev.begin(), ev.end(),[](auto &A, auto &B){ return A.first < B.first; });

                int E = ev.size();
                vector<int> C(E+1), P(E+1), S(E+1);
                C[0] = cnt0;
                for(int e=1;e<=E;e++)
                {
                    C[e] = C[e-1] + ev[e-1].second;
                }
                P[0] = C[0];
                for(int e=1;e<=E;e++)
                {
                    P[e] = max(P[e-1], C[e]);
                }
                S[E] = C[E];
                for(int e=E-1;e>=0;e--)
                {
                    S[e] = max(C[e], S[e+1]);
                }

                {
                    ld denomBm = u.x*(srb[m].x - srb[i].x)
                                +u.y*(srb[m].y - srb[i].y);

                    ld Nbm = (sq(M.x - srb[m].x) + sq(M.y - srb[m].y))
                            - (sq(M.x - srb[i].x) + sq(M.y - srb[i].y));
                    ld Tm = Nbm / (2*denomBm);

                    int pos = int(upper_bound(
                        ev.begin(), ev.end(), Tm,
                        [](const ld &v, auto &pr){ return v < pr.first; }
                    ) - ev.begin());

                    int best = 0;
                    if(denomBm > 0)
                    {
                        best = P[pos];
                    }
                    else
                    {
                        best = S[pos];
                    }

                    answer = max(answer, best);
                }
            }
        }

        cout<<answer<<endl;
    }
    return 0;
}