#include <bits/stdc++.h>
using namespace std;

struct Point
{
    double x, y;
};

static const double EPS = 1e-9;

inline double dist2(Point A, Point B)
{
    double dx = A.x - B.x, dy = A.y - B.y;
    return dx*dx + dy*dy;
}

inline bool lt(double a, double b)
{
    return a + EPS < b;
}

inline bool le(double a, double b)
{
    return a < b + EPS;
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;
    while (T--)
    {
        int n;
        cin >> n;

        vector<Point> srb(3), dot(n);
        for (int i=0;i<3;i++)
        {
            cin>>srb[i].x>>srb[i].y;
        }

        for (int  i=0;i<n;i++)
        {
            cin>>dot[i].x>>dot[i].y;
        }

        int best=0;

        // jedna crvena, r = 0
        for (int i = 0; i < n; i++)
        {
            int cnt = 0;
            for (int j = 0; j < n; j++)
            {
                if (le(dist2(dot[i], dot[j]), 0.0))
                {
                    cnt++;
                }
            }
            best = max(best, cnt);
        }

        // dve crvene
        for (int i=0;i<n;i++)
        {
            for(int j=i+1;j<n;j++)
            {
                Point C;
                C.x = (dot[i].x + dot[j].x) * 0.5;
                C.y = (dot[i].y + dot[j].y) * 0.5;
                double R2 = dist2(dot[i], dot[j]) * 0.25;

                bool ok = true;
                for(auto &P : srb)
                {
                    if (lt(dist2(C, P), R2))
                    {
                        ok = false;
                        break;
                    }
                }
                if(!ok)
                {
                    continue;
                }

                int cnt = 0;
                for(auto &P : dot)
                {
                    if (le(dist2(C, P), R2))
                    {
                        cnt++;
                    }
                }

                best = max(best, cnt);
            }
        }

        // dve plave
        for (int i=0;i<3;i++)
        {
            for(int j=i+1;j<3;j++)
            {
                Point C;
                C.x = (srb[i].x + srb[j].x) * 0.5;
                C.y = (srb[i].y + srb[j].y) * 0.5;
                double R2 = dist2(srb[i], srb[j]) * 0.25;

                bool ok = true;
                for(auto &P : srb)
                {
                    if(lt(dist2(C, P), R2))
                    {
                        ok = false;
                        break;
                    }
                }
                if(!ok)
                {
                    continue;
                }

                int cnt = 0;
                for(auto &P : dot)
                {
                    if(le(dist2(C, P), R2))
                    {
                        cnt++;
                    }
                }

                best = max(best, cnt);
            }
        }

        auto tryCircle = [&](Point A,Point B,Point C)
        {
            double D = 2.0 * (
                A.x * (B.y - C.y) +
                B.x * (C.y - A.y) +
                C.x * (A.y - B.y)
            );

            if(fabs(D) < EPS)
            {
                return;
            }

            double A2 = A.x * A.x + A.y * A.y;
            double B2 = B.x * B.x + B.y * B.y;
            double C2 = C.x * C.x + C.y * C.y;

            Point O;
            O.x = (A2 * (B.y - C.y) + B2 * (C.y - A.y) + C2 * (A.y - B.y)) / D;
            O.y = (A2 * (C.x - B.x) + B2 * (A.x - C.x) + C2 * (B.x - A.x)) / D;
            double R2 = dist2(O, A);

            for(auto &P : srb)
            {
                if (lt(dist2(O, P), R2))
                {
                    return;
                }
            }

            int cnt = 0;
            for(auto &P : dot)
            {
                if (le(dist2(O, P), R2))
                {
                    cnt++;
                }
            }
            best = max(best, cnt);
        };

        // dve crvene i plava
        for(int i=0;i<n;i++)
        {
            for(int j=i+1;j<n;j++)
            {
                for(int b=0;b<3;b++)
                {
                    tryCircle(dot[i], dot[j], srb[b]);
                }
            }
        }

        // dve plave i crvena
        for(int i=0;i<n;i++)
        {
            for(int b1=0;b1<3;b1++)
            {
                for(int b2=b1+1;b2<3;b2++)
                {
                    tryCircle(dot[i], srb[b1], srb[b2]);
                }
            }
        }

        // tri plave
        tryCircle(srb[0], srb[1], srb[2]);

        cout<<best<<endl;
    }
    return 0;
}