#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
using namespace std;

struct Tacka {
    long long x, y;
};

long long rastojanje_kvadrat(const Tacka& a, const Tacka& b) {
    return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
}

bool u_krugu(const Tacka& centar, long long poluprecnik_kvadrat, const Tacka& t) {
    return rastojanje_kvadrat(centar, t) <= poluprecnik_kvadrat;
}

int resi_jedan_primer(int n, const vector<Tacka>& srpske, const vector<Tacka>& tudje) {
    int maksimalno = 0;
    for (int i = 0; i < 3; i++) {
        for (int j = i + 1; j < 3; j++) {
            for (int k = j + 1; k < 3; k++) {
                const Tacka& A = srpske[i];
                const Tacka& B = srpske[j];
                const Tacka& C = srpske[k];
                long long D = 2 * (A.x * (B.y - C.y) + B.x * (C.y - A.y) + C.x * (A.y - B.y));
                if (D == 0) continue;
                
                long long Ux_num = (A.x * A.x + A.y * A.y) * (B.y - C.y) +
                                   (B.x * B.x + B.y * B.y) * (C.y - A.y) +
                                   (C.x * C.x + C.y * C.y) * (A.y - B.y);
                long long Uy_num = (A.x * A.x + A.y * A.y) * (C.x - B.x) +
                                   (B.x * B.x + B.y * B.y) * (A.x - C.x) +
                                   (C.x * C.x + C.y * C.y) * (B.x - A.x);
                
                Tacka centar = {Ux_num / D, Uy_num / D};
                long long poluprecnik_kvadrat = rastojanje_kvadrat(centar, A);
                
                int broj = 0;
                for (const auto& t : tudje) {
                    if (u_krugu(centar, poluprecnik_kvadrat, t)) {
                        broj++;
                    }
                }
                maksimalno = max(maksimalno, broj);
            }
        }
    }
    return maksimalno;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int T;
    cin >> T;
    vector<int> rezultati;
    while (T--) {
        int n;
        cin >> n;
        vector<Tacka> srpske(3);
        for (int i = 0; i < 3; i++) {
            cin >> srpske[i].x >> srpske[i].y;
        }
        vector<Tacka> tudje(n);
        for (int i = 0; i < n; i++) {
            cin >> tudje[i].x >> tudje[i].y;
        }
        rezultati.push_back(resi_jedan_primer(n, srpske, tudje));
    }
    for (int res : rezultati) {
        cout << res << "\n";
    }
    return 0;
}