import math

# Funkcija za izracunavanje kvadrata rastojanja izmedu dve tacke
def dist2(x1, y1, x2, y2):
    return (x1 - x2) ** 2 + (y1 - y2) ** 2

# Funkcija koja proverava da li je tacka (tx, ty) unutar kruga definisanog centrom (cx, cy) i poluprecnikom r
def is_within_circle(tx, ty, cx, cy, r2):
    return dist2(tx, ty, cx, cy) <= r2

# Funkcija koja rešava problem za jedan test
def solve(n, serbian_points, foreign_points):
    max_stolen = 0
    
    # Idemo kroz sve moguce kombinacije 3 srpska lista
    for i in range(3):
        for j in range(i+1, 3):
            for k in range(j+1, 3):
                # Koristimo 3 srpska lista kao potencijalne tacke kruga
                x1, y1 = serbian_points[i]
                x2, y2 = serbian_points[j]
                x3, y3 = serbian_points[k]
                
                # Izracunavamo centar i poluprecnik kruga koji se dodaje 3 tacke
                # Koristimo geometrijski metod za izracunavanje kružnog opisa nad 3 tacke
                
                # Matrica za rešavanje (determinanta)
                d = 2 * (x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2))
                
                if d == 0:
                    continue
                
                cx = ((x1 * x1 + y1 * y1) * (y2 - y3) + (x2 * x2 + y2 * y2) * (y3 - y1) + (x3 * x3 + y3 * y3) * (y1 - y2)) / d
                cy = ((x1 * x1 + y1 * y1) * (x3 - x2) + (x2 * x2 + y2 * y2) * (x1 - x3) + (x3 * x3 + y3 * y3) * (x2 - x1)) / d
                
                # Poluprecnik kruga
                r2 = dist2(cx, cy, x1, y1)  # Kvadrat poluprecnika
                
                # Sada proveravamo koliko stranih tacaka je unutar kruga
                stolen = 0
                for fx, fy in foreign_points:
                    if is_within_circle(fx, fy, cx, cy, r2):
                        stolen += 1
                
                max_stolen = max(max_stolen, stolen)
    
    return max_stolen

# Funkcija koja rešava sve testove
def main():
    T = int(input())  # Broj testova
    for _ in range(T):
        n = int(input())  # Broj stranih listova
        serbian_points = [tuple(map(int, input().split())) for _ in range(3)]
        foreign_points = [tuple(map(int, input().split())) for _ in range(n)]
        
        # Rešavanje trenutnog testa
        result = solve(n, serbian_points, foreign_points)
        print(result)

if __name__ == "__main__":
    main()