import math

def rastojanje2(x1, y1, x2, y2):
    return (x1 - x2) ** 2 + (y1 - y2) ** 2

def u_krugu(tx, ty, cx, cy, r2):
    return rastojanje2(tx, ty, cx, cy) <= r2

def resi(broj_stranih, srpski, strani):
    max_ukradeno = 0

    for i in range(3):
        for j in range(i + 1, 3):
            for k in range(j + 1, 3):
                x1, y1 = srpski[i]
                x2, y2 = srpski[j]
                x3, y3 = srpski[k]
                
                imenilac = 2 * (x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2))
                
                if imenilac == 0:
                    continue 
                
                cx = ((x1**2 + y1**2) * (y2 - y3) + (x2**2 + y2**2) * (y3 - y1) + (x3**2 + y3**2) * (y1 - y2)) / imenilac
                cy = ((x1**2 + y1**2) * (x3 - x2) + (x2**2 + y2**2) * (x1 - x3) + (x3**2 + y3**2) * (x2 - x1)) / imenilac
                
                poluprecnik2 = rastojanje2(cx, cy, x1, y1)
                
                ukradeno = 0
                for fx, fy in strani:
                    if u_krugu(fx, fy, cx, cy, poluprecnik2):
                        ukradeno += 1
                
                max_ukradeno = max(max_ukradeno, ukradeno)
    
    return max_ukradeno

def glavni():
    t = int(input())  # Broj test primera
    for _ in range(t):
        broj_stranih = int(input())
        srpski = [tuple(map(int, input().split())) for _ in range(3)]
        strani = [tuple(map(int, input().split())) for _ in range(broj_stranih)]
        
        rezultat = resi(broj_stranih, srpski, strani)
        print(rezultat)

if __name__ == "__main__":
    glavni()