using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading;
using System.Threading.Tasks;


namespace Kvalifikacije
{
    struct Point
    {
        public double X, Y;
        public Point(double x, double y) { X = x; Y = y; }
        public static Point operator -(Point a, Point b) => new Point(a.X - b.X, a.Y - b.Y);
    }

    class Program
    {
        const double x = 1e20;

        static double Tacka(Point a, Point b) => a.X * b.X + a.Y * b.Y;
        static double Sq(double x) => x * x;

        static Point Centar(Point A, Point B, Point C)
        {
            double x1 = A.X, y1 = A.Y;
            double x2 = B.X, y2 = B.Y;
            double x3 = C.X, y3 = C.Y;
            double D = 2 * (x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2));
            double A1 = x1 * x1 + y1 * y1;
            double A2 = x2 * x2 + y2 * y2;
            double A3 = x3 * x3 + y3 * y3;
            double Ux = (A1 * (y2 - y3) + A2 * (y3 - y1) + A3 * (y1 - y2)) / D;
            double Uy = (A1 * (x3 - x2) + A2 * (x1 - x3) + A3 * (x2 - x1)) / D;
            return new Point(Ux, Uy);
        }

        static void Main()
        {
            var cin = new StreamReader(Console.OpenStandardInput());
            var cout = new StreamWriter(Console.OpenStandardOutput());
            int T = int.Parse(cin.ReadLine());
            while (T-- > 0)
            {
                int n = int.Parse(cin.ReadLine());
                var plavi = new Point[3];
                for (int i = 0; i < 3; i++)
                {
                    var sp = cin.ReadLine().Split();
                    plavi[i] = new Point(
                        double.Parse(sp[0], CultureInfo.InvariantCulture),
                        double.Parse(sp[1], CultureInfo.InvariantCulture)
                    );
                }

                var crveni = new Point[n];
                for (int i = 0; i < n; i++)
                {
                    var sp = cin.ReadLine().Split();
                    crveni[i] = new Point(
                        double.Parse(sp[0], CultureInfo.InvariantCulture),
                        double.Parse(sp[1], CultureInfo.InvariantCulture)
                    );
                }

                int rez = 0;

                {
                    var Cc = Centar(plavi[0], plavi[1], plavi[2]);
                    double R2 = Sq(Cc.X - plavi[0].X) + Sq(Cc.Y - plavi[0].Y);
                    int cnt = 0;
                    foreach (var p in crveni)
                        if (Sq(Cc.X - p.X) + Sq(Cc.Y - p.Y) <= R2 + 1e-9)
                            cnt++;
                    rez = Math.Max(rez, cnt);
                }

                for (int i = 0; i < 3; i++)
                {
                    for (int j = i + 1; j < 3; j++)
                    {
                        int l = 3 - i - j;

                        var Bi = plavi[i];
                        var Bj = plavi[j];
                        var M = new Point((Bi.X + Bj.X) * 0.5, (Bi.Y + Bj.Y) * 0.5);
                        var dij = new Point(Bj.X - Bi.X, Bj.Y - Bi.Y);
                        double dlen = Math.Sqrt(Sq(dij.X) + Sq(dij.Y));
                        if (dlen < 1e-12) continue;
                        var u = new Point(dij.Y / dlen, -dij.X / dlen);

                        var Bl = plavi[l];
                        double Al = Tacka(u, new Point(Bi.X - Bl.X, Bi.Y - Bl.Y));
                        double Bl2 = (Sq(M.X - Bl.X) + Sq(M.Y - Bl.Y))
                                    - (Sq(M.X - Bi.X) + Sq(M.Y - Bi.Y));
                        double tmin = -x, tmax = x;

                        if (Math.Abs(Al) < 1e-15)
                        {
                            if (Bl2 > 0)
                                continue;
                        }
                        else if (Al > 0)
                        {
                            tmin = Math.Max(tmin, -Bl2 / (2 * Al));
                        }
                        else
                        {
                            tmax = Math.Min(tmax, -Bl2 / (2 * Al));
                        }
                        if (tmin > tmax) continue;

                        var events = new List<(double pos, int delta)>(n * 2);
                        foreach (var p in crveni)
                        {
                            double Ak = Tacka(u, new Point(Bi.X - p.X, Bi.Y - p.Y));
                            double Bk2 = (Sq(M.X - p.X) + Sq(M.Y - p.Y))
                                       - (Sq(M.X - Bi.X) + Sq(M.Y - Bi.Y));
                            double lo = -x, hi = x;
                            if (Math.Abs(Ak) < 1e-15)
                            {
                                if (Bk2 > 0)
                                    continue;
                            }
                            else if (Ak > 0)
                            {
                                hi = -Bk2 / (2 * Ak);
                            }
                            else
                            {
                                lo = -Bk2 / (2 * Ak);
                            }
                            if (lo < tmin) lo = tmin;
                            if (hi > tmax) hi = tmax;
                            if (lo > hi) continue;

                            events.Add((lo, +1));
                            events.Add((hi, -1));
                        }

                        if (events.Count == 0)
                            continue;
                        events.Sort((a, b) =>
                        {
                            int c = a.pos.CompareTo(b.pos);
                            if (c != 0) return c;
                            return b.delta.CompareTo(a.delta);
                        });
                        int cur = 0, best = 0;
                        foreach (var e in events)
                        {
                            cur += e.delta;
                            if (cur > best) best = cur;
                        }

                        rez = Math.Max(rez, best);
                    }
                }

                cout.WriteLine(rez);
            }

            cout.Flush();
        }
    }
}