using System;
using System.Collections.Generic;
using System.Globalization;

namespace Kvalifikacije
{
    struct Ev { public double p; public int d; public Ev(double p_, int d_) { p = p_; d = d_; } }

    class Program
    {
        static void Main(string[] args)
        {
            var cf = CultureInfo.InvariantCulture;
            if (!int.TryParse(Console.ReadLine(), out int t)) return;
            while (t-- > 0)
            {
                int nv = int.Parse(Console.ReadLine());
                double[,] bb = new double[3, 2];
                for (int i = 0; i < 3; i++)
                {
                    var tk = Console.ReadLine().Split();
                    bb[i, 0] = double.Parse(tk[0], cf);
                    bb[i, 1] = double.Parse(tk[1], cf);
                }
                double[] rx = new double[nv], ry = new double[nv];
                for (int i = 0; i < nv; i++)
                {
                    var tk = Console.ReadLine().Split();
                    rx[i] = double.Parse(tk[0], cf);
                    ry[i] = double.Parse(tk[1], cf);
                }
                int ans = 0;
                {
                    double x1 = bb[0, 0], y1 = bb[0, 1],
                           x2 = bb[1, 0], y2 = bb[1, 1],
                           x3 = bb[2, 0], y3 = bb[2, 1];
                    double d = 2 * (x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2));
                    double s1 = x1 * x1 + y1 * y1, s2 = x2 * x2 + y2 * y2, s3 = x3 * x3 + y3 * y3;
                    double cx = (s1 * (y2 - y3) + s2 * (y3 - y1) + s3 * (y1 - y2)) / d;
                    double cy = (s1 * (x3 - x2) + s2 * (x1 - x3) + s3 * (x2 - x1)) / d;
                    double r2 = (cx - x1) * (cx - x1) + (cy - y1) * (cy - y1);
                    int c0 = 0;
                    for (int i = 0; i < nv; i++)
                    {
                        double dx = rx[i] - cx, dy = ry[i] - cy;
                        if (dx * dx + dy * dy <= r2 + 1e-9) c0++;
                    }
                    if (c0 > ans) ans = c0;
                }
                for (int k = 0; k < 3; k++)
                {
                    int m = (k + 1) % 3, o = (k + 2) % 3;
                    double[] l = new double[nv], r = new double[nv];
                    for (int i = 0; i < nv; i++)
                    {
                        double ag = Math.Atan2(ry[i] - bb[k, 1], rx[i] - bb[k, 0]);
                        if (ag < 0) ag += 2 * Math.PI;
                        double l0 = ag - Math.PI / 2; if (l0 < 0) l0 += 2 * Math.PI;
                        double r0 = ag + Math.PI / 2; if (r0 >= 2 * Math.PI) r0 -= 2 * Math.PI;
                        l[i] = l0; r[i] = r0;
                    }

                    var g1 = new List<(double, double)>();
                    var g2 = new List<(double, double)>();
                    Action<int, List<(double, double)>> bh = (p, gg) =>
                    {
                        double ag = Math.Atan2(bb[p, 1] - bb[k, 1], bb[p, 0] - bb[k, 0]);
                        double dr = ag + Math.PI; if (dr >= 2 * Math.PI) dr -= 2 * Math.PI;
                        double a = dr - Math.PI / 2; if (a < 0) a += 2 * Math.PI;
                        double b = dr + Math.PI / 2; if (b >= 2 * Math.PI) b -= 2 * Math.PI;
                        if (a <= b) gg.Add((a, b));
                        else { gg.Add((a, 2 * Math.PI)); gg.Add((0, b)); }
                    };
                    bh(m, g1); bh(o, g2);

                    var wg = new List<(double, double)>();
                    foreach (var p1 in g1)
                        foreach (var p2 in g2)
                        {
                            double a = Math.Max(p1.Item1, p2.Item1),
                                   b = Math.Min(p1.Item2, p2.Item2);
                            if (a <= b) wg.Add((a, b));
                        }

                    foreach (var seg in wg)
                    {
                        var evs = new List<Ev>();
                        double wl = seg.Item1, wr = seg.Item2;
                        for (int i = 0; i < nv; i++)
                        {
                            if (l[i] <= r[i])
                            {
                                double a = Math.Max(l[i], wl), b = Math.Min(r[i], wr);
                                if (a <= b) { evs.Add(new Ev(a, +1)); evs.Add(new Ev(b, -1)); }
                            }
                            else
                            {
                                double a1 = Math.Max(l[i], wl), b1 = Math.Min(2 * Math.PI, wr);
                                if (a1 <= b1) { evs.Add(new Ev(a1, +1)); evs.Add(new Ev(b1, -1)); }
                                double a2 = Math.Max(0, wl), b2 = Math.Min(r[i], wr);
                                if (a2 <= b2) { evs.Add(new Ev(a2, +1)); evs.Add(new Ev(b2, -1)); }
                            }
                        }
                        evs.Sort((u, vv) => { int c = u.p.CompareTo(vv.p); return c != 0 ? c : vv.d.CompareTo(u.d); });
                        int cr = 0, bs = 0;
                        foreach (var e in evs) { cr += e.d; if (cr > bs) bs = cr; }
                        if (bs > ans) ans = bs;
                    }
                    {
                        double u1x = bb[m, 0] - bb[k, 0], u1y = bb[m, 1] - bb[k, 1];
                        double m1x = (bb[k, 0] + bb[m, 0]) * 0.5, m1y = (bb[k, 1] + bb[m, 1]) * 0.5;
                        double u2x = bb[o, 0] - bb[k, 0], u2y = bb[o, 1] - bb[k, 1];
                        double m2x = (bb[k, 0] + bb[o, 0]) * 0.5, m2y = (bb[k, 1] + bb[o, 1]) * 0.5;
                        double d1 = u1x * m1x + u1y * m1y,
                               d2 = u2x * m2x + u2y * m2y;
                        double dt = u1x * u2y - u2x * u1y;
                        double cx = (d1 * u2y - d2 * u1y) / dt,
                               cy = (u1x * d2 - u2x * d1) / dt;
                        double r2b = (cx - bb[k, 0]) * (cx - bb[k, 0]) + (cy - bb[k, 1]) * (cy - bb[k, 1]);
                        int c1 = 0;
                        for (int i = 0; i < nv; i++)
                        {
                            double dx = rx[i] - cx, dy = ry[i] - cy;
                            if (dx * dx + dy * dy <= r2b + 1e-9) c1++;
                        }
                        if (c1 > ans) ans = c1;

                        for (int t2 = 0; t2 < 2; t2++)
                        {
                            int p = (t2 == 0 ? m : o);
                            double nx = bb[p, 0] - bb[k, 0], ny = bb[p, 1] - bb[k, 1];
                            double vx = (t2 == 0 ? u2x : u1x), vy = (t2 == 0 ? u2y : u1y);
                            double ux = ny, uy = -nx;
                            if (ux * vx + uy * vy > 0) { ux = -ux; uy = -uy; }

                            int bc = 0;
                            var evL = new List<Ev>();
                            for (int i = 0; i < nv; i++)
                            {
                                double dx = rx[i] - bb[k, 0], dy = ry[i] - bb[k, 1];
                                double mx = (bb[k, 0] + rx[i]) * 0.5, my = (bb[k, 1] + ry[i]) * 0.5;
                                double A = ux * dx + uy * dy,
                                       Bc = dx * (mx - cx) + dy * (my - cy);
                                if (Math.Abs(A) < 1e-12)
                                {
                                    if (Bc <= 0) bc++;
                                }
                                else if (A > 0)
                                {
                                    if (Bc <= 0) bc++;
                                    else { double s0 = Bc / A; if (s0 >= 0) evL.Add(new Ev(s0, +1)); }
                                }
                                else
                                {
                                    if (Bc <= 0)
                                    {
                                        bc++;
                                        double s0 = Bc / A; if (s0 >= 0) evL.Add(new Ev(s0, -1));
                                    }
                                }
                            }
                            evL.Sort((u, vv) => { int c = u.p.CompareTo(vv.p); return c != 0 ? c : vv.d.CompareTo(u.d); });
                            int cr2 = bc, bs2 = bc;
                            foreach (var e in evL) { cr2 += e.d; if (cr2 > bs2) bs2 = cr2; }
                            if (bs2 > ans) ans = bs2;
                        }
                    }
                }

                Console.WriteLine(ans);
            }
        }
    }
}