#include <bits/stdc++.h>
using namespace std;

typedef double ll;
struct Point {
    ll x;
    ll y;
};

struct Line {
    ll a;
    ll b;
    ll c;
};

void Print(Line l1, string s) {
    cout << s << " (A:" << l1.a << ", B: " << l1.b << ", C: " << l1.c << ")" << endl;
}

void Print(Point p1, string s) {
    cout << s << " (X:" << p1.x << ", Y: " << p1.y << ")" << endl;
}
const int MAXN = 10010;

Line povezujuca(Point p1, Point p2) {
    ll x1 = p1.x, y1 = p1.y;
    ll x2 = p2.x, y2 = p2.y;

    ll a = y2 - y1;  // Slope in the numerator form
    ll b = x1 - x2;  // Negate x difference
    ll c = a * x1 + b * y1;  // Use the point (x1, y1) to calculate c

    return {a, b, -c};  // Line equation: ax + by + c = 0
}

Line simetrala(Line l, Point p) {
    ll a1 = l.a, b1 = l.b, c1 = l.c;

    ll m_perp_num = b1; 
    ll m_perp_den = -a1; 

    ll x0 = p.x, y0 = p.y;

    ll a = m_perp_num;
    ll b = m_perp_den;
    ll c = -(a * x0 + b * y0);

    return {a, b, c};
}

Line simetrala(Point p1, Point p2) {
    return simetrala(povezujuca(p1, p2), Point{(p1.x + p2.x)/ 2, (p1.y + p2.y)/2});
}



Point intersect(Line l1, Line l2) {
    ll d = l1.a * l2.b - l2.a * l1.b;
    if (d == 0) {
        return Point{INT_MAX, INT_MAX};
    }
    ll x = -(l1.c * l2.b - l2.c * l1.b) / d;
    ll y = -(l1.a * l2.c - l2.a * l1.c) / d;
    return Point{x, y};
}

ll cross(Point A, Point B, Point C) {
    ll ABx = B.x - A.x;
    ll ABy = B.y - A.y;
    ll ACx = C.x - A.x;
    ll ACy = C.y - A.y;
    return ABx * ACy - ABy * ACx;
}

ll dist(Point A, Point B) {
    ll dx = A.x - B.x;
    ll dy = A.y - B.y;
    return sqrt(dx * dx + dy * dy);
}

Point tacke[MAXN];

int globalAns = 0;

void solve(Point a, Point b, Point c, int n) {
    Line ab = simetrala(a, b);
    Line bc = simetrala(b, c);
    Point m = Point{(a.x + b.x) / 2, (a.y + b.y)/ 2};
    Point centarOpisane = intersect(ab, bc);
   // Print(centarOpisane, "centarOpisane");
   // Print(ab, "Simetrala a b");
    int ans = 0;
    ll crossOpisane = cross(a, b, centarOpisane);
    ll dOpisaneM = dist(centarOpisane, m);
    vector<pair<ll, ll>> wtf;

    ll crossA = cross(m, centarOpisane, a);

    for (int i = 0; i < n; i++) {
        Line l;
        if (cross(m, centarOpisane, tacke[i]) / crossA > 0) {
            l = simetrala(a, tacke[i]);
        }
        else {
            l = simetrala(b, tacke[i]);
        }

        Point pp = intersect(ab, l); 
      
     

        ll d = dist(pp, m);
        if (cross(a, b, pp) / crossOpisane > 0) {
            d *= -1;
        }
        if (cross(a, b, tacke[i]) / crossOpisane > 0) {
            if (d < 0 && -d > dOpisaneM) {
                // nikad nece biti gas
            }
            else {
                wtf.push_back({d, -1});
                //cout << "Gore: " << d << endl;
                ans++;
            }
        }
        else {
            if (d < 0 && -d > dOpisaneM) {
                ans++;
            }
            else {
              wtf.push_back({d, +1});
            }
        }
    }


    sort(wtf.begin(), wtf.end());
    globalAns = max(globalAns, ans);
    for (int i = 0; i < wtf.size(); i++) {
        if (i != wtf.size() - 1) {
            if (wtf[i+1].first != wtf[i].first) {
                globalAns = max(globalAns, ans);
            }
        }
        ans += wtf[i].second;
    }
    globalAns = max(globalAns, ans);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int t;
    cin >> t;
    Point a, b, c;
    while(t--) {
        int n;
        cin >> n;
        globalAns = 0;
        //cout << n << endl;

        for (int i = 0; i < MAXN; i++) {
            tacke[i].x = tacke[i].y = 0;
        }
        cin >> a.x >> a.y;
        cin >> b.x >> b.y;
        cin >> c.x >> c.y;
        for (int i = 0; i < n; i++) {
            cin >> tacke[i].x >> tacke[i].y;
        }

        solve(a, b, c, n);
        solve(a, c, b, n);
        solve(b, c, a, n);
    }

    cout << globalAns << endl;

    return 0;
}