#include <bits/stdc++.h>
using namespace std;

typedef long double ll;
struct Point {
    ll x;
    ll y;
};

struct Line {
    ll a;
    ll b;
    ll c;
};

void Print(Line l1, string s) {
    cout << s << " (A:" << l1.a << ", B: " << l1.b << ", C: " << l1.c << ")" << endl;
}

void Print(Point p1, string s) {
    cout << s << " (X:" << p1.x << ", Y: " << p1.y << ")" << endl;
}
const int MAXN = 100010;

Line povezujuca(Point p1, Point p2) {
    ll x1 = p1.x, y1 = p1.y;
    ll x2 = p2.x, y2 = p2.y;

    ll a = y2 - y1;  // Slope in the numerator form
    ll b = x1 - x2;  // Negate x difference
    ll c = a * x1 + b * y1;  // Use the point (x1, y1) to calculate c

    return {a, b, -c};  // Line equation: ax + by + c = 0
}

Line simetrala(Line l, Point p) {
    ll a1 = l.a, b1 = l.b, c1 = l.c;

    ll m_perp_num = b1; 
    ll m_perp_den = -a1; 

    ll x0 = p.x, y0 = p.y;

    ll a = m_perp_num;
    ll b = m_perp_den;
    ll c = -(a * x0 + b * y0);

    return {a, b, c};
}

Line simetrala(Point p1, Point p2) {
    return simetrala(povezujuca(p1, p2), Point{(p1.x + p2.x)/ 2, (p1.y + p2.y)/2});
}



Point intersect(Line l1, Line l2) {
    ll d = l1.a * l2.b - l2.a * l1.b;
    if (d == 0) {
        return Point{INT_MAX, INT_MAX};
    }
    ll x = -(l1.c * l2.b - l2.c * l1.b) / d;
    ll y = -(l1.a * l2.c - l2.a * l1.c) / d;
    return Point{x, y};
}

ll cross(Point A, Point B, Point C) {
    ll ABx = B.x - A.x;
    ll ABy = B.y - A.y;
    ll ACx = C.x - A.x;
    ll ACy = C.y - A.y;
    return ABx * ACy - ABy * ACx;
}

ll dist2(Point A, Point B) {
    ll dx = A.x - B.x;
    ll dy = A.y - B.y;
    return dx * dx + dy * dy;
}

Point tacke[MAXN];

int globalAns = 0;

void solve(Point a, Point b, Point c, int n) {
  //  cout << "--------------------" << endl;
    Line ab = simetrala(a, b);
    Line bc = simetrala(b, c);
    Point m = Point{(a.x + b.x) / 2.0, (a.y + b.y)/ 2.0};
    Point centarOpisane = intersect(ab, bc);
   // Print(centarOpisane, "centarOpisane");
   // Print(ab, "Simetrala a b");
    int ans = 0;
    ll crossOpisane = cross(a, b, centarOpisane);
    ll dOpisaneM = dist2(centarOpisane, m);

    ll crossC = cross(a, b, c);
    vector<pair<ll, ll>> wtf;

    ll crossA = cross(m, centarOpisane, a);

    //cout << dOpisaneM << endl;

    if (crossOpisane / crossC > 0) {
        // opisana je unutra
    }
    else {
        // opisana je spolja
        dOpisaneM *= -1;
    }


    for (int i = 0; i < n; i++) {
        Line l;
        if (cross(m, centarOpisane, tacke[i]) / crossA > 0) {
            l = simetrala(a, tacke[i]);
        }
        else {
            l = simetrala(b, tacke[i]);
        }

        Point pp = intersect(ab, l); 
      

        ll d = dist2(pp, m);
        if (cross(a, b, pp) / crossC > 0) {
            d *= -1;
        }
       //cout << d << endl;
        d += dOpisaneM;
       // Print(tacke[i], "tacka i");
        if (cross(a, b, tacke[i]) / crossC > 0) {
            if (d < 0) {
                // nikad nece biti gas
               // cout << "nikad nece biti gas" << endl;
            }
            else {
                wtf.push_back({d, -1});
                //cout << "Gore: " << d << endl;
                ans++;
            }
        }
        else {
            if (d < 0) {
                ans++;
            }
            else {
              wtf.push_back({d, +1});
            }
        }
    }
    sort(wtf.begin(), wtf.end());
   // cout << "HHHHHHHHHHHHHHHHHHHHH" << endl;
    // for (int i = 0; i < wtf.size(); i++) {
    //     cout << wtf[i].first << " " << wtf[i].second << endl;
    // }

    globalAns = max(globalAns, ans);
    for (int i = 0; i < wtf.size(); i++) {
        ans += wtf[i].second;
        if (i != wtf.size() - 1) {
            if (wtf[i+1].first != wtf[i].first) {
                globalAns = max(globalAns, ans);
            }
        }
    }
    globalAns = max(globalAns, ans);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int t;
    cin >> t;
    while(t--) {
        int n;
        cin >> n;
        globalAns = 0;
        Point a, b, c;

        for (int i = 0; i < MAXN; i++) {
            tacke[i].x = tacke[i].y = 0;
        }
        cin >> a.x >> a.y;
        cin >> b.x >> b.y;
        cin >> c.x >> c.y;
        a.x *= 2; a.y *= 2;
        b.x *= 2; b.y *= 2;
        c.x *= 2; c.y *= 2;
        for (int i = 0; i < n; i++) {
            cin >> tacke[i].x >> tacke[i].y;
             tacke[i].x *= 2; tacke[i].y *= 2;
        }

        solve(a, b, c, n);
        solve(a, c, b, n);
        solve(b, c, a, n);
        cout << globalAns << endl;
    }


    return 0;
}