#include <iostream>
#include <vector>
#include <cmath>
#include <utility>
using namespace std;

double rastojanje(const pair<int, int>& a, const pair<int, int>& b) {
    int dx = a.first - b.first;
    int dy = a.second - b.second;
    return sqrt(dx * dx + dy * dy);
}

int tacke_unutar_kruga(const vector<pair<int, int>>& tacke, const vector<pair<int, int>>& ostale) {
    double x1 = tacke[0].first, y1 = tacke[0].second;
    double x2 = tacke[1].first, y2 = tacke[1].second;
    double x3 = tacke[2].first, y3 = tacke[2].second;

    double D = 2 * (x1*(y2 - y3) + x2*(y3 - y1) + x3*(y1 - y2));
    
    double rx = ((x1*x1 + y1*y1)*(y2 - y3) + (x2*x2 + y2*y2)*(y3 - y1) + (x3*x3 + y3*y3)*(y1 - y2)) / D;
    double ry = ((x1*x1 + y1*y1)*(x3 - x2) + (x2*x2 + y2*y2)*(x1 - x3) + (x3*x3 + y3*y3)*(x2 - x1)) / D;

    double r = rastojanje({rx, ry}, tacke[0]);
    
    int br = 0;
    for (int i = 0; i < ostale.size(); ++i) {
        if(rastojanje(ostale[i], {rx, ry}) <= r){
            br++;
        }
    }
    return br;
}


int main() {
    int n;
    cin >> n;

    vector<pair<int, int>> tacke(3);
    for (int i = 0; i < 3; ++i)
        cin >> tacke[i].first >> tacke[i].second;

    vector<pair<int, int>> ostale(n);
    for (int i = 0; i < n; ++i)
        cin >> ostale[i].first >> ostale[i].second;

    
    int u=tacke_unutar_kruga(tacke, ostale);
    cout<<u;

    return 0;
}