using System;

namespace kvaltakm2
{
    internal class Program
    {
        static double[] CenterOfCircle(int x1, int y1, int x2, int y2, int x3, int y3)
        {
            double[] c = new double[3];
            c[0] = -(((Math.Pow(x1, 2) - Math.Pow(x3, 2)) * (y1 - y2) + (Math.Pow(y1, 2) - Math.Pow(y3, 2)) * (y1 - y2) + (Math.Pow(x2, 2) - Math.Pow(x1, 2)) * (y1 - y3) + (Math.Pow(y2, 2) - Math.Pow(y1, 2)) * (y1 - y3)) / (2 * ((x3 - x1) * (y1 - y2) - (x2 - x1) * (y1 - y3))));
            c[1] = -(((Math.Pow(x1, 2) - Math.Pow(x3, 2)) * (x1 - x2) + (Math.Pow(y1, 2) - Math.Pow(y3, 2)) * (x1 - x2) + (Math.Pow(x2, 2) - Math.Pow(x1, 2)) * (x1 - x3) + (Math.Pow(y2, 2) - Math.Pow(y1, 2)) * (x1 - x3)) / (2 * ((y3 - y1) * (x1 - x2) - (y2 - y1) * (x1 - x3))));
            c[2] = Math.Sqrt(Math.Pow(x1 - c[0], 2) + Math.Pow(y1 - c[1], 2));
            return c;
        }
        static int InCircle(int[] xu, int[] yu, double a, double b, double r)
        {
            int br = 0;
            for (int i = 3; i < xu.Length; i++)
            {
                bool h = Math.Sqrt(Math.Pow(xu[i] - a, 2) + Math.Pow(yu[i] - b, 2)) <= r;
                bool j = Math.Sqrt(Math.Pow(xu[0] - a, 2) + Math.Pow(yu[0] - b, 2)) >= r;
                bool k = Math.Sqrt(Math.Pow(xu[1] - a, 2) + Math.Pow(yu[1] - b, 2)) >= r;
                bool l = Math.Sqrt(Math.Pow(xu[2] - a, 2) + Math.Pow(yu[2] - b, 2)) >= r;
                if (h && j && k && l)
                {
                    br++;
                }
            }
            return br;
        }
        static void Main(string[] args)
        {
            int t = int.Parse(Console.ReadLine());
            int[] resejna = new int[t];
            for (int i = 0; i < t; i++)
            {
                int n = int.Parse(Console.ReadLine());
                int[] xu = new int[n + 3];
                int[] yu = new int[n + 3];
                for (int j = 0; j < 3; j++)
                {
                    string[] input = Console.ReadLine().Split();
                    xu[j] = int.Parse(input[0]);
                    yu[j] = int.Parse(input[1]);
                }
                for (int j = 0; j < n; j++)
                {
                    string[] input = Console.ReadLine().Split();
                    xu[j + 3] = int.Parse(input[0]);
                    yu[j + 3] = int.Parse(input[1]);
                }
                int maxInCirc = 0;
                for(int j = 0; j < 3; j++)
                {
                    for(int k = 0; k < n+3; k++)
                    {
                        for(int  l = 0; l < n+3; l++)
                        {
                            if(j != k && j != l && k != l)
                            {
                                double[] abr = CenterOfCircle(xu[j], yu[j], xu[k], yu[k], xu[l], yu[l]);
                                int inCirc = InCircle(xu, yu, abr[0], abr[1], abr[2]);
                                if (inCirc > maxInCirc)
                                {
                                    maxInCirc = inCirc;
                                }
                            }
                        }
                    }
                }
                resejna[t] = maxInCirc;
            }
            for(int i = 0; i < t; i++)
            {
                Console.WriteLine(resejna[i]);
            }
        }
    }
}