#include <bits/stdc++.h>
using namespace std;
const double EPS = 1e-8;
struct Point 
{
    double x, y;
};
double d2(Point a, Point b) 
{
    double dx = a.x - b.x, dy = a.y - b.y;
    return dx * dx + dy * dy;
}
bool unutra(Point center, double r2, Point p)
{
    return d2(center, p) < r2 - EPS;
}
bool unutrana(Point c, double r2, Point p) 
{
    return d2(c, p) <= r2 + EPS;
}
Point srednjatacka(Point a, Point b) 
{
    return {(a.x + b.x) / 2, (a.y + b.y) / 2};
}
Point centar(Point a, Point b, Point c) 
{
    double d = 2 * (a.x*(b.y - c.y) + b.x*(c.y - a.y) + c.x*(a.y - b.y));
    double ux = ((a.x*a.x + a.y*a.y)*(b.y - c.y) + (b.x*b.x + b.y*b.y)*(c.y - a.y) + (c.x*c.x + c.y*c.y)*(a.y - b.y)) / d;
    double uy = ((a.x*a.x + a.y*a.y)*(c.x - b.x) + (b.x*b.x + b.y*b.y)*(a.x - c.x) + (c.x*c.x + c.y*c.y)*(b.x - a.x)) / d;
    return {ux, uy};
}
int main() 
{
    int T;
    cin >> T;
    while (T--) 
    {
        int n;
        cin >> n;
        vector<Point> srpski(3);
        for (int i = 0; i < 3; i++)
            cin >> srpski[i].x >> srpski[i].y;
        vector<Point> tudji(n);
        for (int i = 0; i < n; i++)
            cin >> tudji[i].x >> tudji[i].y;
        int res = 1;
        for (int i = 0; i < n; i++) 
        {
            for (int j = i+1; j < n; j++) 
            {
                Point c = srednjatacka(tudji[i], tudji[j]);
                double r2 = d2(c, tudji[i]);
                bool ok = true;
                for (auto& s : srpski)
                    if (unutra(c, r2, s)) ok = false;
                if (!ok) continue;
                int br = 0;
                for (auto& t : tudji)
                    if (unutrana(c, r2, t)) br++;
                res = max(res, br);
            }
        }
        for (int i = 0; i < 3; i++) 
        {
            for (int j = i+1; j < 3; j++) 
            {
                Point c = srednjatacka(srpski[i], srpski[j]);
                double r2 = d2(c, srpski[i]);
                bool ok = true;
                for (auto& s : srpski)
                    if (unutra(c, r2, s)) ok = false;
                if (!ok) continue;
                int br = 0;
                for (auto& t : tudji)
                    if (unutrana(c, r2, t)) br++;
                res = max(res, br);
            }
        }
        for (int i = 0; i < n; i++) 
        {
            for (int j = i+1; j < n; j++) 
            {
                for (int k = j+1; k < n; k++) 
                {
                    Point c = centar(tudji[i], tudji[j], tudji[k]);
                    double r2 = d2(c, tudji[i]);
                    bool ok = true;
                    for (auto& s : srpski)
                        if (unutra(c, r2, s)) ok = false;
                    if (!ok) continue;
                    int br = 0;
                    for (auto& t : tudji)
                        if (unutrana(c, r2, t)) br++;
                    res = max(res, br);
                }
            }
        }
        Point c = centar(srpski[0], srpski[1], srpski[2]);
        double r2 = d2(c, srpski[0]);
        bool ok = true;
        for (auto& s : srpski)
            if (unutra(c, r2, s)) ok = false;
        if (!ok) continue;
        int br = 0;
        for (auto& t : tudji)
            if (unutrana(c, r2, t)) br++;
        res = max(res, br);
        cout << res << '\n';
    }
}