#include <iostream>
#include <cstdio>
#include <vector>
#include <array>
#include <string>
#include <algorithm>
#include <numeric>
#include <map>
#include <unordered_map>
#include <set>
#include <unordered_set>
#include <queue>
#include <cmath>
#include <climits>
#include <iomanip>
#include <limits>
#include <tuple>
#include <stack>
#include <bitset>
#include <cstring>
#include <sstream>
#include <functional>
#include <random>
#define int long long
using namespace std;

struct pt{
    double x,y;
};
double dist2(pt&a,pt&b){
    return (a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y);
}
pt copkr(pt&a,pt&b,pt&c){
    double d=2*(a.x*(b.y-c.y)+b.x*(c.y-a.y)+c.x*(a.y-b.y));
    double a2=a.x*a.x+a.y*a.y;
    double b2=b.x*b.x+b.y*b.y;
    double c2=c.x*c.x+c.y*c.y;
    double ux=(a2*(b.y-c.y)+b2*(c.y-a.y)+c2*(a.y-b.y))/d;
    double uy=(a2*(c.x-b.x)+b2*(a.x-c.x)+c2*(b.x-a.x))/d;
    return {ux,uy};
}
void solve(){
    int n;
    cin>>n;
    vector<pt>a(n+3);
    for(auto&e:a)
        cin>>e.x>>e.y;
    int ans=0;
    for(int i=0;i<a.size()-2;++i){
        for(int j=i+1;j<a.size()-1;++j){
            for(int k=j+1;k<a.size();++k){
                pt pt1=a[i],pt2=a[j],pt3=a[k];
                pt o=copkr(pt1,pt2,pt3);
                double r2=dist2(o,pt1);
                bool ok=1;
                for(int t=0;t<3;++t){
                    if(dist2(o,a[t])<r2){
                        ok=0;
                        break;
                    }
                }
                if(!ok)
                    continue;
                int cnt=0;
                for(int t=3;t<a.size();++t)
                    if(dist2(o,a[t])<=r2)
                        ++cnt;
                ans=max(ans,cnt);
            }
        }
    }
    cout<<ans<<'\n';
}

signed main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int tt;
    cin>>tt;
    while(tt--)
        solve();
    return 0;
}