#include <iostream>
#include <cstdio>
#include <vector>
#include <array>
#include <string>
#include <algorithm>
#include <numeric>
#include <map>
#include <unordered_map>
#include <set>
#include <unordered_set>
#include <queue>
#include <cmath>
#include <climits>
#include <iomanip>
#include <limits>
#include <tuple>
#include <stack>
#include <bitset>
#include <cstring>
#include <sstream>
#include <functional>
#include <random>
#define int long long
using namespace std;

struct pt{
    double x,y;
};
double dist2(pt&a,pt&b){
    return (a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y);
}
pt copkr(pt&a,pt&b,pt&c){
    double ax=a.x,ay=a.y;
    double bx=b.x,by=b.y;
    double cx=c.x,cy=c.y;
    double d=2*(ax*(by-cy)+bx*(cy-ay)+cx*(ay-by));
    double a2=ax*ax+ay*ay;
    double b2=bx*bx+by*by;
    double c2=cx*cx+cy*cy;
    double ux=(a2*(by-cy)+b2*(cy-ay)+c2*(ay-by))/d;
    double uy=(a2*(cx-bx)+b2*(ax-cx)+c2*(bx-ax))/d;
    return {ux,uy};
}
void solve(){
    int n;
    cin>>n;
    vector<pt>a(n+3);
    for(auto&e:a)
        cin>>e.x>>e.y;
    int ans=0;
    for(int i=3;i<a.size()-2;++i){
        for(int j=i+1;j<a.size()-1;++j){
            for(int k=j+1;k<a.size();++k){
                pt pt1=a[i],pt2=a[j],pt3=a[k];
                pt o=copkr(pt1,pt2,pt3);
                double r2=dist2(o,pt1);
                bool ok=1;
                for(int t=0;t<3;++t){
                    if(dist2(o,a[t])<r2){
                        ok=0;
                        break;
                    }
                }
                if(!ok)
                    continue;
                int cnt=0;
                for(int t=3;t<a.size();++t)
                    if(dist2(o,a[t])<=r2)
                        ++cnt;
                ans=max(ans,cnt);
            }
        }
    }
    for(int i=3;i<a.size()-1;++i){
        for(int j=i+1;j<a.size();++j){
            pt p1=a[i],p2=a[j];
            pt o={(p1.x+p2.x)/2,(p1.y+p2.y)/2};
            double r2=dist2(p1,p2)/4.0;
            bool ok=1;
            for(int t=0;t<3;++t){
                if(dist2(o,a[t])<r2){
                    ok=0;
                    break;
                }
            }
            if(!ok)
                continue;
            int cnt=0;
            for(int t=3;t<a.size();++t)
                if(dist2(o,a[t])<=r2)
                    ++cnt;
            ans=max(ans,cnt);
        }
    }
    cout<<ans<<'\n';
}

signed main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int tt;
    cin>>tt;
    while(tt--)
        solve();
    return 0;
}