#include <iostream>
#include <cstdio>
#include <vector>
#include <array>
#include <string>
#include <algorithm>
#include <numeric>
#include <map>
#include <unordered_map>
#include <set>
#include <unordered_set>
#include <queue>
#include <cmath>
#include <climits>
#include <iomanip>
#include <limits>
#include <tuple>
#include <stack>
#include <bitset>
#include <cstring>
#include <sstream>
#include <functional>
#include <random>
#define int long long
#define double long double
using namespace std;

struct pt{
    double x,y;
};
double dist2(pt&a,pt&b){
    return (a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y);
}
pt copkr(pt&a,pt&b,pt&c){
    double A=b.x-a.x,B=b.y-a.y;
    double C=c.x-a.x,D=c.y-a.y;
    double E=A*(a.x+b.x)+B*(a.y+b.y);
    double F=C*(a.x+c.x)+D*(a.y+c.y);
    double G=2*(A*(c.y-b.y)-B*(c.x-b.x));
    if(fabsl(G)<1e-12)
        return{1e18,1e18};
    return {(D*E-B*F)/G,(A*F-C*E)/G};
}
void solve(){
    int n;
    cin>>n;
    vector<pt>a(n+3);
    for(auto&e:a)
        cin>>e.x>>e.y;
    int ans=1;
    for(int i=0;i<a.size();++i){
        for(int j=i+1;j<a.size();++j){
            for(int k=j+1;k<a.size();++k){
                pt pt1=a[i],pt2=a[j],pt3=a[k];
                pt o=copkr(pt1,pt2,pt3);
                if(o.x==1e18)
                    continue;
                double r2=dist2(o,pt1);
                bool ok=1;
                for(int t=0;t<3;++t){
                    if(dist2(o,a[t])<r2-1e-9){
                        ok=0;
                        break;
                    }
                }
                if(!ok)
                    continue;
                int cnt=0;
                for(int t=3;t<a.size();++t)
                    if(dist2(o,a[t])<=r2+1e-9)
                        ++cnt;
                ans=max(ans,cnt);
            }
        }
    }
    for(int i=3;i<a.size();++i){
        for(int j=i+1;j<a.size();++j){
            pt p1=a[i],p2=a[j];
            pt o={(p1.x+p2.x)/2.0,(p1.y+p2.y)/2.0};
            double r2=dist2(p1,p2)/4.0;
            bool ok=1;
            for(int t=0;t<3;++t){
                if(dist2(o,a[t])<r2-1e-9){
                    ok=0;
                    break;
                }
            }
            if(!ok)
                continue;
            int cnt=0;
            for(int t=3;t<a.size();++t)
                if(dist2(o,a[t])<=r2+1e-9)
                    ++cnt;
            ans=max(ans,cnt);
        }
    }
    cout<<ans<<'\n';
}

signed main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int tt;
    cin>>tt;
    while(tt--)
        solve();
    return 0;
}