#include <bits/stdc++.h>

#pragma optimize("O3, unroll-loops")
#pragma target("avx2, bmi, bmi2, lzcnt, popcnt")

#define LD long double 

using namespace std;

const LD EPS = 1e-9;

struct Pt {
    LD x, y;
};

struct Circ {
    Pt cen;
    LD r2; 
};

LD distSq(Pt p1, Pt p2) {
    LD dx = p1.x - p2.x;
    LD dy = p1.y - p2.y;
    return dx * dx + dy * dy;
}

bool isIn(Pt p, const Circ& c) { 
    return distSq(p, c.cen) < c.r2 - EPS;
}

bool isInOrOn(Pt p, const Circ& c) {
    if (c.r2 < -EPS) return false; 
    if (abs(c.r2) < EPS) { 
        return distSq(p,c.cen) < EPS; 
    }
    return distSq(p, c.cen) < c.r2 + EPS;
}

Circ getCirc(Pt p1, Pt p2, Pt p3) {
    if (distSq(p1,p2) < EPS) {
        Pt center = {(p1.x + p3.x) / 2.0L, (p1.y + p3.y) / 2.0L};
        return {center, distSq(p1, center)};
    }
    if (distSq(p1,p3) < EPS) {
        Pt center = {(p1.x + p2.x) / 2.0L, (p1.y + p2.y) / 2.0L};
        return {center, distSq(p1, center)};
    }
    if (distSq(p2,p3) < EPS) {
        Pt center = {(p1.x + p2.x) / 2.0L, (p1.y + p2.y) / 2.0L};
        return {center, distSq(p1, center)};
    }

    LD D = 2 * (p1.x * (p2.y - p3.y) + p2.x * (p3.y - p1.y) + p3.x * (p1.y - p2.y));
    if (abs(D) < EPS) {
        return {{0,0}, -1.0L}; 
    }

    Pt center;
    center.x = ((p1.x * p1.x + p1.y * p1.y) * (p2.y - p3.y) +
                (p2.x * p2.x + p2.y * p2.y) * (p3.y - p1.y) +
                (p3.x * p3.x + p3.y * p3.y) * (p1.y - p2.y)) / D;
    center.y = ((p1.x * p1.x + p1.y * p1.y) * (p3.x - p2.x) +
                (p2.x * p2.x + p2.y * p2.y) * (p1.x - p3.x) +
                (p3.x * p3.x + p3.y * p3.y) * (p2.x - p1.x)) / D;
    
    Circ res;
    res.cen = center;
    res.r2 = distSq(center, p1);
    return res;
}

int countPtsCirc(const Circ& c, const vector<Pt>& s_pts, const vector<Pt>& o_pts) {
    if (c.r2 < -EPS/2.0L) return 0;

    for (const auto& sp : s_pts) {
        if (isIn(sp, c)) {
            return 0;
        }
    }
    int cnt = 0;
    for (const auto& op : o_pts) {
        if (isInOrOn(op, c)) {
            cnt++;
        }
    }
    return cnt;
}

LD crossProd(Pt p1, Pt p2, Pt p) {
    return (p2.x - p1.x) * (p.y - p1.y) - (p2.y - p1.y) * (p.x - p1.x);
}

int countPtsHalf(Pt p1, Pt p2, int sd, const vector<Pt>& s_pts, const vector<Pt>& o_pts) {
    for (const auto& sp : s_pts) {
        LD cp = crossProd(p1, p2, sp);
        if (sd * cp > EPS) { 
            return 0; 
        }
    }

    int cnt = 0;
    for (const auto& op : o_pts) {
        LD cp = crossProd(p1, p2, op);
        if (sd * cp >= -EPS) { 
            cnt++;
        }
    }
    return cnt;
}


void solve(){
    int n_val;
    cin >> n_val;
    vector<Pt> S(3);
    for (int i = 0; i < 3; ++i) cin >> S[i].x >> S[i].y;
    vector<Pt> O(n_val);
    for (int i = 0; i < n_val; ++i) cin >> O[i].x >> O[i].y;

    if (n_val == 0) {
        cout << 0 << endl;
        return;
    }
    int ans = 1; 
    
    Circ c_sss = getCirc(S[0], S[1], S[2]);
    if(c_sss.r2 >= -EPS/2.0L) 
        ans = max(ans, countPtsCirc(c_sss, S, O));

    for (int i = 0; i < 3; ++i) {
        for (int j = i + 1; j < 3; ++j) {
            Pt center_ss_diam = {(S[i].x + S[j].x) / 2.0L, (S[i].y + S[j].y) / 2.0L};
            LD r_sq_ss_diam = distSq(center_ss_diam, S[i]);
            ans = max(ans, countPtsCirc({center_ss_diam, r_sq_ss_diam}, S, O));
            
            if(distSq(S[i],S[j]) > EPS*EPS) {
                ans = max(ans, countPtsHalf(S[i], S[j], 1, S, O));
                ans = max(ans, countPtsHalf(S[i], S[j], -1, S, O));
            }
        }
    }
    
    const int n_stop = 200;

    if (n_val > 0 && n_val <= n_stop) {
        for (int i = 0; i < 3; ++i) {
            for (int j = i + 1; j < 3; ++j) {
                for (int k = 0; k < n_val; ++k) {
                    Circ c_sso = getCirc(S[i], S[j], O[k]);
                    if(c_sso.r2 >= -EPS/2.0L)
                        ans = max(ans, countPtsCirc(c_sso, S, O));
                }
            }
        }

        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < n_val; ++k) {
                Pt center_so_diam = {(S[i].x + O[k].x) / 2.0L, (S[i].y + O[k].y) / 2.0L};
                LD r_sq_so_diam = distSq(center_so_diam, S[i]);
                ans = max(ans, countPtsCirc({center_so_diam, r_sq_so_diam}, S, O));
            }
        }
    
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < n_val; ++k) {
                if (distSq(S[i], O[k]) > EPS * EPS) { 
                    ans = max(ans, countPtsHalf(S[i], O[k], 1, S, O));
                    ans = max(ans, countPtsHalf(S[i], O[k], -1, S, O));
                }
            }
        }
    }
    
    const int VERY_n_stop = 30;
    if (n_val > 0 && n_val <= VERY_n_stop) {
        for (int k = 0; k < n_val; ++k) {
            for (int l = k + 1; l < n_val; ++l) {
                for (int m = 0; m < 3; ++m) {
                    Circ c_oos = getCirc(O[k], O[l], S[m]);
                    if (c_oos.r2 >= -EPS/2.0L) {
                        ans = max(ans, countPtsCirc(c_oos, S, O));
                    }
                }
            }
        }

        for (int k = 0; k < n_val; ++k) {
            for (int l = k + 1; l < n_val; ++l) {
                Pt center_oo_diam = {(O[k].x + O[l].x) / 2.0L, (O[k].y + O[l].y) / 2.0L};
                LD r_sq_oo_diam = distSq(center_oo_diam, O[k]);
                ans = max(ans, countPtsCirc({center_oo_diam, r_sq_oo_diam}, S, O));
            }
        }
    }
    
    cout << ans << endl;
}

int main(){
    std::ios::sync_with_stdio(false); std::cin.tie(0); std::cout.tie(0); 
    int t;
    cin >> t;
    while(t--){
        solve();
    }
    return 0;
}