#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
void DBG() { cerr << "]" << endl; }
template<class H, class... T> void DBG(H h, T... t) { cerr << to_string(h); if(sizeof...(t)) cerr << ", "; DBG(t...); }
#define dbg(...) cerr << "[" << #__VA_ARGS__ << "]: [", DBG(__VA_ARGS__)

const int N = 1e5 + 3;
pair<int, int> points[3], lisce[N];

enum orijemtacija {Counterclockwise, Collinear, Clockwise};

orijemtacija orijentisi(ll x1, ll y1, ll x2, ll y2, ll x3, ll y3) {
    ll val = (y2-y1)*(x3-x2) - (y3-y2)*(x2-x1);
    if (val == 0) return Collinear;
    if (val > 0) return Clockwise;
    if (val < 0) return Counterclockwise;
}

void solve() {
    int n; cin >> n;
    for (int i = 0; i < 3; i++) cin >> points[i].first >> points[i].second;
    for (int i = 0; i < n; i++) cin >> lisce[i].first >> lisce[i].second;

    int ans = 0;
    for (int i = 0; i < 3; i++) {
        int j = (i+1)%3;
        int res = 0;
        for (int k = 0; k < n; k++) {
            auto [x3, y3] = lisce[k];
            auto [x1, y1] = points[i];
            auto [x2, y2] = points[j];

            res += (orijentisi(x1, y1, x2, y2, x3, y3) == Clockwise);
        }
        ans = max(ans, res);
    }

    cout << ans << "\n";
}

signed main() {
    ios::sync_with_stdio(false); cin.tie(0);
	int t=1; cin >> t;
	while (t--) {
        solve();
	}
}